<div class="bg-white border border-gray-200 rounded-lg shadow-xs dark:bg-gray-800 dark:border-gray-700">
    <div class="p-6 border-b border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">{{ __('admin.general_settings_title') }}</h3>
        <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">{{ __('admin.general_settings_subtitle') }}</p>
    </div>
    <form wire:submit="save" class="p-6 space-y-4">
        <!-- Site Name -->
        <div>
            <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.site_name_label') }}</label>
            <input type="text" wire:model="site_name" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
            @error('site_name') <span class="text-sm text-red-600 dark:text-red-400">{{ $message }}</span> @enderror
        </div>

        <!-- Site Description -->
        <div>
            <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.site_description_label') }}</label>
            <textarea wire:model="site_description" rows="3" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="{{ __('admin.site_description_placeholder') }}"></textarea>
            @error('site_description') <span class="text-sm text-red-600 dark:text-red-400">{{ $message }}</span> @enderror
        </div>

        <!-- Site Tagline -->
        <div>
            <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.site_tagline_label') }}</label>
            <input type="text" wire:model="site_tagline" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="{{ __('admin.site_tagline_placeholder') }}">
            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ __('admin.site_tagline_help') }}</p>
            @error('site_tagline') <span class="text-sm text-red-600 dark:text-red-400">{{ $message }}</span> @enderror
        </div>

        <!-- Purchase Code -->
        <div>
            <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.purchase_code_label') }}</label>
            <input type="text"
                   wire:model="purchase_code"
                   @if(config('app.demo')) disabled @endif
                   class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 @if(config('app.demo')) opacity-60 cursor-not-allowed @endif"
                   placeholder="@if(config('app.demo')){{ __('admin.hidden_in_demo') }}@else XXXX-XXXX-XXXX-XXXX @endif">
            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ __('admin.purchase_code_help') }}</p>
            @error('purchase_code') <span class="text-sm text-red-600 dark:text-red-400">{{ $message }}</span> @enderror
        </div>

        <!-- Logo Upload (Light Mode) -->
        <div>
            <x-file-upload
                wire-model="logo"
                accept="image/*"
                :label="__('admin.logo_light')"
                :help-text="__('admin.logo_help')"
                :current-file="$current_logo"
                :max-size="2"
                preview-type="image"
            />

            @if($current_logo)
                @if(config('app.demo'))
                    <button type="button" disabled title="{{ __('admin.disabled_in_demo') }}" class="mt-2 rounded-lg bg-red-700 px-3 py-2 text-xs font-medium text-white dark:bg-red-600 cursor-not-allowed opacity-50">
                        {{ __('admin.delete_logo') }}
                    </button>
                @else
                    <button
                        type="button"
                        wire:click="removeLogo"
                        class="mt-2 rounded-lg bg-red-700 px-3 py-2 text-xs font-medium text-white hover:bg-red-800 focus:outline-hidden focus:ring-4 focus:ring-red-300 dark:bg-red-600 dark:hover:bg-red-700 dark:focus:ring-red-800">
                        {{ __('admin.delete_logo') }}
                    </button>
                @endif
            @endif
        </div>

        <!-- Logo Upload (Dark Mode) -->
        <div>
            <x-file-upload
                wire-model="logo_dark"
                accept="image/*"
                :label="__('admin.logo_dark_label')"
                :help-text="__('admin.logo_help')"
                :current-file="$current_logo_dark"
                :max-size="2"
                preview-type="image"
            />

            @if($current_logo_dark)
                @if(config('app.demo'))
                    <button type="button" disabled title="{{ __('admin.disabled_in_demo') }}" class="mt-2 rounded-lg bg-red-700 px-3 py-2 text-xs font-medium text-white dark:bg-red-600 cursor-not-allowed opacity-50">
                        {{ __('admin.delete_dark_logo') }}
                    </button>
                @else
                    <button
                        type="button"
                        wire:click="removeDarkLogo"
                        class="mt-2 rounded-lg bg-red-700 px-3 py-2 text-xs font-medium text-white hover:bg-red-800 focus:outline-hidden focus:ring-4 focus:ring-red-300 dark:bg-red-600 dark:hover:bg-red-700 dark:focus:ring-red-800">
                        {{ __('admin.delete_dark_logo') }}
                    </button>
                @endif
            @endif
        </div>

        <!-- Favicon Upload -->
        <div>
            <x-file-upload
                wire-model="favicon"
                accept="image/*,.ico"
                :label="__('admin.favicon_label')"
                :help-text="__('admin.favicon_help')"
                :current-file="$current_favicon"
                :max-size="1"
                preview-type="image"
            />

            @if($current_favicon)
                @if(config('app.demo'))
                    <button type="button" disabled title="{{ __('admin.disabled_in_demo') }}" class="mt-2 rounded-lg bg-red-700 px-3 py-2 text-xs font-medium text-white dark:bg-red-600 cursor-not-allowed opacity-50">
                        {{ __('admin.delete_favicon') }}
                    </button>
                @else
                    <button
                        type="button"
                        wire:click="removeFavicon"
                        class="mt-2 rounded-lg bg-red-700 px-3 py-2 text-xs font-medium text-white hover:bg-red-800 focus:outline-hidden focus:ring-4 focus:ring-red-300 dark:bg-red-600 dark:hover:bg-red-700 dark:focus:ring-red-800">
                        {{ __('admin.delete_favicon') }}
                    </button>
                @endif
            @endif
        </div>

        <!-- Default Color Theme -->
        <div>
            <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.default_theme_label') }}</label>
            <select wire:model="default_theme" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                <option value="system">{{ __('admin.theme_system') }}</option>
                <option value="light">{{ __('admin.theme_light') }}</option>
                <option value="dark">{{ __('admin.theme_dark') }}</option>
            </select>
            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ __('admin.theme_help') }}</p>
            @error('default_theme') <span class="text-sm text-red-600 dark:text-red-400">{{ $message }}</span> @enderror
        </div>

        <!-- System Currency -->
        <div>
            <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.currency_label') }}</label>
            <select wire:model="system_currency" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                @foreach(\App\Helpers\CurrencyHelper::getCurrencyOptions() as $code => $label)
                    <option value="{{ $code }}">{{ $label }}</option>
                @endforeach
            </select>
            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ __('admin.currency_help') }}</p>
            @error('system_currency') <span class="text-sm text-red-600 dark:text-red-400">{{ $message }}</span> @enderror
        </div>

        <!-- Default Language -->
        <div>
            <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.default_language') }}</label>
            @php
                $activeLanguages = \App\Models\Language::where('status', 'active')->orderBy('name')->get();
                $currentLang = $activeLanguages->firstWhere('code', $default_locale);
            @endphp
            <div class="relative" x-data="{ open: false }">
                <button
                    @click="open = !open"
                    type="button"
                    class="relative w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 text-start"
                >
                    <span class="flex items-center gap-2">
                        @if($currentLang?->flag)
                            <span class="fi fi-{{ strtolower($currentLang->flag) }} fis rounded-sm"></span>
                        @endif
                        <span>{{ $currentLang?->name ?? __('common.select') }}</span>
                    </span>
                    <span class="absolute inset-y-0 end-0 flex items-center pe-2.5 pointer-events-none">
                        <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                        </svg>
                    </span>
                </button>

                <div
                    x-show="open"
                    @click.away="open = false"
                    x-transition:enter="transition ease-out duration-100"
                    x-transition:enter-start="transform opacity-0 scale-95"
                    x-transition:enter-end="transform opacity-100 scale-100"
                    x-transition:leave="transition ease-in duration-75"
                    x-transition:leave-start="transform opacity-100 scale-100"
                    x-transition:leave-end="transform opacity-0 scale-95"
                    x-cloak
                    class="absolute z-50 w-full mt-1 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg shadow-lg max-h-60 overflow-y-auto"
                >
                    @foreach($activeLanguages as $language)
                        <button
                            type="button"
                            wire:click="$set('default_locale', '{{ $language->code }}')"
                            @click="open = false"
                            class="w-full flex items-center gap-2 px-3 py-2 text-sm text-start hover:bg-gray-100 dark:hover:bg-gray-600 {{ $default_locale === $language->code ? 'bg-blue-50 dark:bg-blue-900/20 text-blue-600 dark:text-blue-400' : 'text-gray-900 dark:text-white' }}"
                        >
                            <span class="fi fi-{{ strtolower($language->flag) }} fis rounded-sm"></span>
                            <span>{{ $language->name }}</span>
                            @if($default_locale === $language->code)
                                <svg class="w-4 h-4 ms-auto text-blue-600 dark:text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                            @endif
                        </button>
                    @endforeach
                </div>
            </div>
            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ __('admin.default_language_description') }}</p>
            @error('default_locale') <span class="text-sm text-red-600 dark:text-red-400">{{ $message }}</span> @enderror
        </div>

        <!-- Landing Page Toggle -->
        <div class="flex items-center justify-between p-4 border border-gray-200 dark:border-gray-700 rounded-lg">
            <div>
                <p class="text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.landing_page_toggle') }}</p>
                <p class="text-xs text-gray-500 dark:text-gray-400">{{ __('admin.landing_page_help') }}</p>
            </div>
            <x-toggle wire-model="landing_page_enabled" />
        </div>

        @if(config('app.demo'))
            <button type="button" disabled title="{{ __('admin.disabled_in_demo') }}" class="text-white bg-blue-700 font-medium rounded-lg text-sm px-5 py-2.5 dark:bg-blue-600 cursor-not-allowed opacity-50">
                {{ __('common.save') }}
            </button>
        @else
            <button type="submit" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-hidden dark:focus:ring-blue-800">
                {{ __('common.save') }}
            </button>
        @endif
    </form>
</div>
