<div>
    <!-- Modal backdrop -->
    <div x-data="{ show: @entangle('showModal') }"
         x-show="show"
         x-cloak
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition ease-in duration-150"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         class="fixed inset-0 z-50 overflow-y-auto"
         aria-labelledby="modal-title"
         role="dialog"
         aria-modal="true">

        <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:block sm:p-0">
            <!-- Background overlay -->
            <div class="fixed inset-0 transition-opacity bg-gray-500/75 dark:bg-gray-900/75"
                 @click="$wire.closeModal()"
                 aria-hidden="true"></div>

            <!-- Center modal -->
            <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

            <!-- Modal panel -->
            <div x-show="show"
                 x-transition:enter="transition ease-out duration-300"
                 x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                 x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                 x-transition:leave="transition ease-in duration-200"
                 x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                 x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                 class="relative z-10 inline-block w-full max-w-2xl p-6 my-8 overflow-hidden text-start align-middle transition-all transform bg-white dark:bg-gray-800 shadow-xl rounded-lg">

                <!-- Modal header -->
                <div class="flex items-center justify-between pb-4 mb-4 border-b border-gray-200 dark:border-gray-700">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                        {{ $isEdit ? __('admin.edit_builder') : __('admin.add_builder') }}
                        @if($isDefault)
                            <span class="ms-2 inline-flex items-center px-2.5 py-0.5 rounded text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300">
                                {{ __('admin.default') }}
                            </span>
                        @endif
                    </h3>
                    <button type="button"
                            wire:click="closeModal"
                            class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ms-auto inline-flex items-center dark:hover:bg-gray-700 dark:hover:text-white">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
                        </svg>
                    </button>
                </div>

                <!-- Modal body -->
                <form wire:submit="save">
                    {{-- Purchase code warning for default builder --}}
                    @if($isDefault && $purchaseCodeMissing)
                        <div class="mb-4 p-4 bg-yellow-50 border border-yellow-200 rounded-lg dark:bg-yellow-900/20 dark:border-yellow-800">
                            <div class="flex items-center">
                                <svg class="w-5 h-5 text-yellow-600 dark:text-yellow-400 me-2 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-sm font-medium text-yellow-800 dark:text-yellow-300">
                                    {{ __('admin.purchase_code_not_set_warning') }}
                                </span>
                            </div>
                            <p class="mt-1 ms-7 text-sm text-yellow-700 dark:text-yellow-400">
                                {{ __('admin.purchase_code_not_set_description') }}
                            </p>
                        </div>
                    @endif

                    <!-- Section 1: Server Connection -->
                    <div class="mb-6">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <!-- Server Name -->
                            <div class="md:col-span-3">
                                <label for="name" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                    {{ __('admin.builder_name') }} <span class="text-red-500">*</span>
                                </label>
                                <input type="text"
                                       wire:model="name"
                                       id="name"
                                       class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                       placeholder="{{ __('admin.builder_name_placeholder') }}">
                                @error('name')
                                    <p class="mt-1 text-sm text-red-600 dark:text-red-500">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Server URL -->
                            <div class="md:col-span-2">
                                <label for="url" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                    {{ __('admin.server_url') }}
                                    @if(!$isDefault)
                                        <span class="text-red-500">*</span>
                                    @else
                                        <span class="ms-1 text-xs text-gray-500 dark:text-gray-400">({{ __('admin.locked') }})</span>
                                    @endif
                                </label>
                                <input type="text"
                                       wire:model="url"
                                       id="url"
                                       @if($isDefault) disabled @endif
                                       class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 @if($isDefault) opacity-60 cursor-not-allowed @endif"
                                       placeholder="{{ __('admin.server_url_placeholder') }}">
                                @error('url')
                                    <p class="mt-1 text-sm text-red-600 dark:text-red-500">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Server Port -->
                            <div>
                                <label for="port" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                    {{ __('admin.port') }}
                                    @if(!$isDefault)
                                        <span class="text-red-500">*</span>
                                    @else
                                        <span class="ms-1 text-xs text-gray-500 dark:text-gray-400">({{ __('admin.locked') }})</span>
                                    @endif
                                </label>
                                <input type="number"
                                       wire:model="port"
                                       id="port"
                                       @if($isDefault) disabled @endif
                                       class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 @if($isDefault) opacity-60 cursor-not-allowed @endif"
                                       placeholder="8899">
                                @error('port')
                                    <p class="mt-1 text-sm text-red-600 dark:text-red-500">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Section 2: Authentication -->
                    <div class="mb-6 pb-6 border-b border-gray-200 dark:border-gray-700">
                        <div>
                            <label for="server_key" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                {{ __('admin.server_key') }}
                                @if(!$isDefault)
                                    <span class="text-red-500">*</span>
                                @else
                                    <span class="ms-1 text-xs text-gray-500 dark:text-gray-400">({{ __('admin.from_purchase_code') }})</span>
                                @endif
                            </label>
                            <div class="flex gap-2" x-data="{
                                copied: false,
                                copyKey() {
                                    const input = document.getElementById('server_key');
                                    const value = input ? input.value : '';
                                    if (!value) return;

                                    if (navigator.clipboard && window.isSecureContext) {
                                        navigator.clipboard.writeText(value).then(() => this.showCopied());
                                    } else {
                                        const textarea = document.createElement('textarea');
                                        textarea.value = value;
                                        textarea.style.position = 'fixed';
                                        textarea.style.opacity = '0';
                                        document.body.appendChild(textarea);
                                        textarea.select();
                                        document.execCommand('copy');
                                        document.body.removeChild(textarea);
                                        this.showCopied();
                                    }
                                },
                                showCopied() {
                                    this.copied = true;
                                    setTimeout(() => this.copied = false, 2000);
                                }
                            }">
                                <input type="text"
                                       wire:model="server_key"
                                       id="server_key"
                                       @if($isDefault) disabled @endif
                                       class="flex-1 min-w-0 bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 @if($isDefault) opacity-60 cursor-not-allowed @endif"
                                       placeholder="@if(config('app.demo') && $isDefault){{ __('admin.hidden_in_demo') }}@else{{ __('admin.server_key_placeholder') }}@endif">

                                @if(!$isDefault)
                                    <!-- Copy Button -->
                                    <button type="button"
                                            @click="copyKey()"
                                            class="px-4 py-2.5 text-sm font-medium text-gray-900 bg-white border border-gray-300 rounded-lg hover:bg-gray-100 focus:ring-4 focus:outline-hidden focus:ring-gray-200 dark:bg-gray-700 dark:text-white dark:border-gray-600 dark:hover:bg-gray-600 dark:focus:ring-gray-700">
                                        <svg x-show="!copied" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/>
                                        </svg>
                                        <svg x-show="copied" x-cloak class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                        </svg>
                                    </button>

                                    <!-- Generate Button -->
                                    @if(config('app.demo'))
                                        <button type="button" disabled title="{{ __('admin.disabled_in_demo') }}"
                                                class="px-4 py-2.5 text-sm font-medium text-white bg-gray-700 rounded-lg dark:bg-gray-600 cursor-not-allowed opacity-50">
                                            {{ __('admin.generate') }}
                                        </button>
                                    @else
                                        <button type="button"
                                                wire:click="generateServerKey"
                                                class="px-4 py-2.5 text-sm font-medium text-white bg-gray-700 rounded-lg hover:bg-gray-800 focus:ring-4 focus:outline-hidden focus:ring-gray-300 dark:bg-gray-600 dark:hover:bg-gray-700 dark:focus:ring-gray-800">
                                            {{ __('admin.generate') }}
                                        </button>
                                    @endif
                                @endif
                            </div>
                            @error('server_key')
                                <p class="mt-1 text-sm text-red-600 dark:text-red-500">{{ $message }}</p>
                            @else
                                @if($isDefault)
                                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ __('admin.server_key_from_purchase_code_help') }}</p>
                                @else
                                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ __('admin.server_key_help') }}</p>
                                @endif
                            @enderror
                        </div>
                    </div>

                    <!-- Section 3: Build Configuration -->
                    <div class="mb-4">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <!-- Max Queue -->
                            <div>
                                <label for="max_queue" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                    {{ __('admin.max_queue') }} <span class="text-red-500">*</span>
                                </label>
                                <input type="number"
                                       wire:model="max_queue"
                                       id="max_queue"
                                       min="1"
                                       max="100"
                                       class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                       placeholder="5">
                                @error('max_queue')
                                    <p class="mt-1 text-sm text-red-600 dark:text-red-500">{{ $message }}</p>
                                @else
                                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ __('admin.max_queue_help') }}</p>
                                @enderror
                            </div>

                            <!-- Build Credit Cost -->
                            <div>
                                <label for="credit_cost" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                    {{ __('admin.build_credit_cost') }} <span class="text-red-500">*</span>
                                </label>
                                <input type="number"
                                       wire:model="credit_cost"
                                       id="credit_cost"
                                       min="1"
                                       max="100"
                                       class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                       placeholder="1">
                                @error('credit_cost')
                                    <p class="mt-1 text-sm text-red-600 dark:text-red-500">{{ $message }}</p>
                                @else
                                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ __('admin.credit_cost_help') }}</p>
                                @enderror
                            </div>

                            <!-- Platforms -->
                            <div x-data="{
                                    open: false,
                                    translations: {
                                        selectPlatforms: {{ Js::from(__('admin.select_platforms')) }},
                                        platforms: {{ Js::from(__('common.platforms')) }},
                                        platform: {{ Js::from(__('common.platform')) }}
                                    },
                                    get selectedCount() {
                                        return @this.platforms.length;
                                    },
                                    get buttonText() {
                                        const count = @this.platforms.length;
                                        if (count === 0) return this.translations.selectPlatforms;
                                        return count + ' ' + (count > 1 ? this.translations.platforms : this.translations.platform) + ' selected';
                                    },
                                    togglePlatform(platformId) {
                                        const current = @this.platforms;
                                        const index = current.indexOf(platformId);

                                        if (index > -1) {
                                            current.splice(index, 1);
                                        } else {
                                            current.push(platformId);
                                        }

                                        @this.platforms = current;
                                    },
                                    isSelected(platformId) {
                                        return @this.platforms.includes(platformId);
                                    }
                                 }"
                                 @click.away="open = false">
                                <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                    {{ __('admin.supported_platforms') }} <span class="text-red-500">*</span>
                                </label>

                                @if(count($this->availablePlatforms) === 0)
                                    <p class="text-sm text-gray-500 dark:text-gray-400">{{ __('admin.no_platforms_available') }}</p>
                                @else
                                    <div class="relative">
                                        <button type="button"
                                                @click="open = !open"
                                                class="w-full flex items-center justify-between px-4 py-2.5 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 focus:ring-4 focus:outline-hidden focus:ring-blue-300 dark:bg-gray-700 dark:text-white dark:border-gray-600 dark:hover:bg-gray-600 dark:focus:ring-blue-800">
                                            <span x-text="buttonText"></span>
                                            <svg class="w-4 h-4 ms-2 transition-transform" :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                            </svg>
                                        </button>

                                        <div x-show="open"
                                             x-cloak
                                             x-transition
                                             class="absolute z-10 w-full mt-2 bg-white border border-gray-200 rounded-lg shadow-lg dark:bg-gray-700 dark:border-gray-600 max-h-64 overflow-y-auto">

                                            @foreach($this->availablePlatforms as $platformOption)
                                                <label class="flex items-center px-3 py-2.5 hover:bg-gray-50 dark:hover:bg-gray-600 cursor-pointer"
                                                       :class="{ 'bg-blue-50 dark:bg-blue-900/10': isSelected('{{ $platformOption['id'] }}') }">
                                                    <input type="checkbox"
                                                           :checked="isSelected('{{ $platformOption['id'] }}')"
                                                           @change="togglePlatform('{{ $platformOption['id'] }}')"
                                                           class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:bg-gray-600 dark:border-gray-500">
                                                    <span class="ms-3 text-sm text-gray-900 dark:text-white">{{ $platformOption['name'] }}</span>
                                                </label>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif

                                @error('platforms')
                                    <p class="mt-2 text-sm text-red-600 dark:text-red-500">{{ $message }}</p>
                                @else
                                    <p class="mt-2 text-xs text-gray-500 dark:text-gray-400">{{ __('admin.platforms_help') }}</p>
                                @enderror
                            </div>

                            <!-- Status -->
                            <div>
                                <label for="status" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                    {{ __('common.status') }} <span class="text-red-500">*</span>
                                </label>
                                <select wire:model="status"
                                        id="status"
                                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                    <option value="active">{{ __('common.active') }}</option>
                                    <option value="inactive">{{ __('common.inactive') }}</option>
                                </select>
                                @error('status')
                                    <p class="mt-1 text-sm text-red-600 dark:text-red-500">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Modal footer -->
                    <div class="flex items-center justify-end gap-3 pt-4 border-t border-gray-200 dark:border-gray-700">
                        <button type="button"
                                wire:click="closeModal"
                                class="text-gray-900 bg-white border border-gray-300 hover:bg-gray-100 focus:ring-4 focus:outline-hidden focus:ring-gray-200 font-medium rounded-lg text-sm px-5 py-2.5 dark:bg-gray-700 dark:text-white dark:border-gray-600 dark:hover:bg-gray-600 dark:hover:border-gray-600 dark:focus:ring-gray-700">
                            {{ __('common.cancel') }}
                        </button>
                        @if(config('app.demo'))
                            <button type="button" disabled title="{{ __('admin.disabled_in_demo') }}"
                                    class="text-white bg-blue-700 font-medium rounded-lg text-sm px-5 py-2.5 dark:bg-blue-600 cursor-not-allowed opacity-50">
                                {{ __('common.submit') }}
                            </button>
                        @else
                            <button type="submit"
                                    class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-hidden focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                                {{ __('common.submit') }}
                            </button>
                        @endif
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
