<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Platform Plugin Translation Strings
    |--------------------------------------------------------------------------
    |
    | The following language lines are used by the platform plugin blade
    | templates for settings and configuration pages.
    |
    */

    // General Settings
    'general' => [
        'basic_information' => 'Temel Bilgiler',
        'basic_information_description' => 'Uygulamanız hakkında temel detaylar',
        'app_name' => 'Uygulama adı',
        'app_name_placeholder' => 'Harika Uygulamam',
        'app_name_help' => 'Cihaz ana ekranında görüntülenir',
        'website_url' => 'Web Sitesi URL\'si',
        'website_url_placeholder' => 'https://ornek.com',
        'website_url_help' => 'Web sitenizin veya web uygulamanızın tam URL\'si',
        'configuration' => 'Yapılandırma',
        'configuration_description' => 'Teknik ayarlar ve tanımlayıcılar',
        'app_id' => 'UYGULAMA ID',
        'app_id_tooltip' => 'Uygulama mağazaları tarafından kullanılan benzersiz paket tanımlayıcı',
        'app_id_placeholder' => 'com.ornek.uygulama',
        'app_id_help' => 'Uygulama ID oluşturulduktan sonra değiştirilemez',
        'copy' => 'Kopyala',
        'copied' => 'Kopyalandı!',
        'screen_orientation' => 'Ekran yönü',
        'screen_orientation_help' => 'Uygulamanızın cihazda nasıl döneceğini kontrol eder',
        'orientation_system' => 'Sistem',
        'orientation_portrait' => 'Dikey',
        'orientation_landscape' => 'Yatay',
        'app_language' => 'Uygulama dili (ISO kodu)',
        'app_language_help' => 'Uygulama içeriğiniz için birincil dil',
    ],

    // Design Settings
    'design' => [
        'layout_template' => 'Düzen Şablonu',
        'layout_template_description' => 'Uygulamanız için navigasyon yapısını seçin',
        'layout_app_bar_drawer' => 'Uygulama Çubuğu + Çekmece',
        'layout_app_bar_tabs' => 'Uygulama Çubuğu + Navigasyon Sekmeleri',
        'layout_app_bar' => 'Uygulama Çubuğu',
        'layout_blank' => 'Boş',
        'progress_indicator' => 'İlerleme Göstergesi',
        'progress_indicator_help' => 'Sayfalar yüklenirken gösterilen yükleme göstergesi stili',
        'progress_disable' => 'Devre Dışı',
        'progress_linear' => 'Doğrusal',
        'progress_circular' => 'Dairesel',
        'progress_indicator_color' => 'İlerleme Göstergesi Rengi',
        'progress_indicator_color_help' => 'Yükleme ilerleme göstergesinin rengi',
        'show_app_bar_title' => 'Uygulama çubuğunda mevcut web sayfası başlığını göster',
        'show_app_bar_title_help' => 'Üst çubukta mevcut sayfanın başlığını görüntüle',
        'nav_tab_icon_colors' => 'Navigasyon Sekmesi Simge Renkleri',
        'nav_tab_icon_colors_help' => 'Açık ve koyu modda aktif olmayan sekme simgelerinin rengi',
        'active_tab_colors' => 'Aktif Sekme Renkleri',
        'active_tab_colors_help' => 'Açık ve koyu modda seçili sekmenin rengi',
        'light_mode' => 'Açık Mod',
        'dark_mode' => 'Koyu Mod',
        'theme_colors' => 'Tema Renkleri',
        'theme_colors_description' => 'Uygulamanızın görünümünü tanımlayan birincil renkler',
        'theme_color' => 'Tema Rengi',
        'theme_color_help' => 'Uygulamanız boyunca kullanılan ana renk',
        'enable_dynamic_colors' => 'Material You Dinamik Renklerini Etkinleştir (Android 12+)',
        'enable_dynamic_colors_help' => 'Etkinleştirildiğinde, uygulamanız Android 12+ cihazlarda kullanıcının duvar kağıdından renklere uyum sağlar. Bu, yukarıdaki tema rengini geçersiz kılar.',
        'text_color_light' => 'Metin Rengi (Açık Mod)',
        'text_color_light_help' => 'Açık modda varsayılan metin ve simge rengi',
        'text_color_dark' => 'Metin Rengi (Koyu Mod)',
        'text_color_dark_help' => 'Koyu modda varsayılan metin ve simge rengi',
    ],

    // Icon Settings
    'icon' => [
        'app_icon' => 'Uygulama Simgesi',
        'app_icon_description' => 'Uygulama simgenizi icon.kitchen\'dan ZIP dosyası olarak yükleyin',
        'current_icon' => 'Mevcut Simge',
        'icon_zip_uploaded' => 'Simge ZIP\'i yüklendi',
        'icon_zip_uploaded_description' => 'Çıkarılan simgeler Android ve Web platformları için kullanılabilir',
        'default_icon' => 'Varsayılan Simge',
        'default_icon_description' => 'Varsayılanı değiştirmek için özel bir simge yükleyin',
        'delete' => 'Sil',
        'upload_zip_file' => 'ZIP Dosyası Yükle',
        'upload_zip_help' => 'icon.kitchen\'dan ZIP dosyası (MAKS. 10MB)',
        'how_to_create' => 'Simgenizi nasıl oluşturursunuz:',
        'step_visit' => 'Ziyaret edin',
        'step_design' => 'Uygulama simgenizi tasarlayın',
        'step_download' => 'Tüm platform simgelerini içeren ZIP dosyasını indirin',
        'step_upload' => 'ZIP dosyasını buraya yükleyin',
        'zip_file_info' => 'ZIP dosyası Android ve Web platformları için simgeler içermelidir (Maks 10MB)',
        'upload_icon' => 'Simge Yükle',
    ],

    // Splashscreen Settings
    'splashscreen' => [
        'appearance' => 'Açılış Ekranı Görünümü',
        'appearance_description' => 'Arka plan, görüntüleme süresi ve animasyon efektlerini özelleştirin',
        'background_type' => 'Arka Plan Türü',
        'background_type_color' => 'Düz Renk',
        'background_type_image' => 'Arka Plan Görseli',
        'background_color' => 'Arka Plan Rengi',
        'background_image' => 'Arka Plan Görseli',
        'background_image_help' => 'Sadece PNG (MAKS. 2MB)',
        'delete_background_image' => 'Arka Plan Görselini Sil',
        'display_duration' => 'Görüntüleme Süresi:',
        'seconds' => 'saniye',
        'animation_effect' => 'Animasyon Efekti',
        'animation_fade' => 'Solma',
        'animation_slide' => 'Kayma',
        'animation_zoom' => 'Yakınlaştırma',
        'animation_none' => 'Yok',
        'branding' => 'Açılış Ekranı Markalaması',
        'branding_description' => 'Açılış ekranınıza logo, başlık, alt başlık ve metin stili ekleyin',
        'show_logo' => 'Açılış Ekranında Logo Göster',
        'logo_image' => 'Logo Görseli',
        'logo_image_help' => 'Şeffaf PNG önerilir (MAKS. 2MB)',
        'delete_logo' => 'Logoyu Sil',
        'logo_size' => 'Logo Boyutu:',
        'logo_size_small' => 'Küçük (60dp)',
        'logo_size_medium' => 'Orta (150dp)',
        'logo_size_large' => 'Büyük (240dp)',
        'logo_size_help' => 'Optimal görünüm için logo boyutunu ayarlayın',
        'title' => 'Başlık',
        'title_placeholder' => 'Harika Uygulamam',
        'subtitle' => 'Alt Başlık',
        'subtitle_placeholder' => 'En iyi uygulamaya hoş geldiniz',
        'text_theme' => 'Metin Teması',
        'text_theme_light' => 'Açık (Beyaz metin)',
        'text_theme_dark' => 'Koyu (Siyah metin)',
    ],

    // Drawer Settings
    'drawer' => [
        'appearance' => 'Çekmece Görünümü',
        'appearance_description' => 'Navigasyon çekmecenizin arka planını ve görsel stilini özelleştirin',
        'drawer_mode' => 'Çekmece Modu',
        'drawer_mode_help' => 'Çekmece arka planının nasıl görüneceğini seçin',
        'mode_default' => 'Varsayılan (Tema Rengi)',
        'mode_color' => 'Özel Renk',
        'mode_image' => 'Arka Plan Görseli',
        'background_color' => 'Arka Plan Rengi',
        'background_color_help' => 'Çekmece için özel arka plan rengi',
        'background_image' => 'Arka Plan Görseli',
        'background_image_help' => 'Sadece PNG (MAKS. 2MB). Önerilen: 1080x1920px',
        'delete_background_image' => 'Arka Plan Görselini Sil',
        'branding' => 'Çekmece Markalaması',
        'branding_description' => 'Çekmece başlığına logo, başlık ekleyin ve metin görünümünü özelleştirin',
        'show_logo' => 'Çekmecede Logo Göster',
        'show_logo_help' => 'Çekmece başlığında bir logo görüntüle',
        'logo_light' => 'Çekmece Logosu (Açık Mod)',
        'logo_light_help' => 'Şeffaf PNG gerekli (MAKS. 2MB) - Uygulama açık temadayken gösterilir',
        'delete_light_logo' => 'Açık Logoyu Sil',
        'logo_dark' => 'Çekmece Logosu (Koyu Mod)',
        'logo_dark_help' => 'Şeffaf PNG gerekli (MAKS. 2MB) - Uygulama koyu temadayken gösterilir',
        'delete_dark_logo' => 'Koyu Logoyu Sil',
        'logo_size' => 'Logo Boyutu:',
        'logo_size_small' => 'Küçük (40dp)',
        'logo_size_medium' => 'Orta (120dp)',
        'logo_size_large' => 'Büyük (200dp)',
        'logo_size_help' => 'Optimal görünüm için logo boyutunu ayarlayın',
        'drawer_title' => 'Çekmece Başlığı',
        'drawer_title_placeholder' => 'Uygulamam',
        'drawer_title_help' => 'Çekmece başlığında görüntülenen başlık',
        'drawer_subtitle' => 'Çekmece Alt Başlığı',
        'drawer_subtitle_placeholder' => 'Uygulamama hoş geldiniz',
        'drawer_subtitle_help' => 'Başlığın altında gösterilen alt başlık veya slogan',
        'text_theme' => 'Metin Teması',
        'text_theme_help' => 'Çekmece başlığı ve menü öğeleri için metin rengi',
        'text_theme_light' => 'Açık (Beyaz metin)',
        'text_theme_dark' => 'Koyu (Siyah metin)',
        'item_colors' => 'Çekmece Öğe Renkleri',
        'item_colors_description' => 'Çekmece menü öğeleri için simge ve metin renklerini özelleştirin',
        'item_icon_colors' => 'Çekmece Öğe Simge Renkleri',
        'item_icon_colors_help' => 'Açık ve koyu modda aktif olmayan çekmece öğe simgeleri ve metinlerinin rengi',
        'active_item_colors' => 'Aktif Öğe Renkleri',
        'active_item_colors_help' => 'Açık ve koyu modda seçili/aktif çekmece öğesinin rengi',
        'light_mode' => 'Açık Mod',
        'dark_mode' => 'Koyu Mod',
    ],

    // Navigation Settings
    'navigation' => [
        'bottom_nav_bar' => 'Alt Navigasyon Çubuğu',
        'bottom_nav_bar_description' => 'Alt navigasyon sekmesi öğelerini yapılandırın (maks 8 öğe)',
        'add_item' => '+ Öğe Ekle',
        'no_navigation_items' => 'Navigasyon öğesi yapılandırılmadı',
        'add_first_navigation_item' => 'İlk navigasyon öğenizi ekleyin',
        'home_tab_badge' => 'Ana Sekme - Ana URL ile Senkronize',
        'home_item_badge' => 'Ana Öğe - Ana URL ile Senkronize',
        'label' => 'Etiket',
        'label_placeholder_home' => 'Ana Sayfa',
        'label_placeholder_about' => 'Hakkımızda',
        'action_type' => 'Eylem Türü',
        'action_internal' => 'Dahili Bağlantı',
        'action_external' => 'Harici Bağlantı',
        'action_hosted_page' => 'Barındırılan Sayfa',
        'action_share' => 'Paylaş',
        'action_email' => 'E-posta Gönder',
        'action_call' => 'Arama Yap',
        'url' => 'URL',
        'email_address' => 'E-posta Adresi',
        'phone_number' => 'Telefon Numarası',
        'hosted_page' => 'Barındırılan Sayfa',
        'select_page' => 'Bir sayfa seçin',
        'synced_from_general' => 'Genel Ayarlardan otomatik senkronize edilir',
        'icon' => 'Simge',
        'select_icon' => 'Simge Seç',
        'search_icons' => 'Simgeleri ara...',
        'home_tab_cannot_delete' => 'Ana sekme silinemez',
        'home_item_cannot_delete' => 'Ana öğe silinemez',
        'max_navigation_items' => 'Maksimum 8 navigasyon öğesine ulaşıldı (Ana sekme hariç)',
        'app_bar_buttons' => 'Uygulama Çubuğu Düğmeleri',
        'app_bar_buttons_description' => 'Uygulama çubuğunun sağ üstüne eylem düğmeleri ekleyin (maks 3 düğme)',
        'add_button' => '+ Düğme Ekle',
        'no_app_bar_buttons' => 'Uygulama çubuğu düğmesi yapılandırılmadı',
        'add_first_app_bar_button' => 'İlk uygulama çubuğu düğmenizi ekleyin',
        'max_app_bar_buttons' => 'Maksimum 3 uygulama çubuğu düğmesine ulaşıldı',
        'drawer_menu_items' => 'Çekmece Menü Öğeleri',
        'drawer_menu_items_description' => 'Navigasyon çekmecesi menü öğelerini yapılandırın (1 ana + 9 ek öğe)',
        'no_drawer_items' => 'Çekmece menü öğesi yapılandırılmadı',
        'add_first_drawer_item' => 'İlk çekmece menü öğenizi ekleyin',
        'max_drawer_items' => 'Maksimum 9 ek öğeye ulaşıldı (ana öğe dahil toplam 10)',
        'behavior_settings' => 'Davranış Ayarları',
        'behavior_settings_description' => 'Kullanıcı etkileşimlerini yapılandırın',
        'pull_to_refresh' => 'Yenilemek İçin Çek',
        'pull_to_refresh_description' => 'Kullanıcıların aşağı çekerek içeriği yenilemesine izin ver',
        'swipe_navigation' => 'Kaydırma Navigasyonu',
        'swipe_navigation_description' => 'Kullanıcıların kenardan kaydırarak geri gitmesine izin ver',
        'swipe_navigation_disabled' => 'Hareket çakışmalarını önlemek için çekmece düzenlerinde devre dışı',
        'preserve_tab_state' => 'Sekme Durumunu Koru',
        'preserve_tab_state_description' => 'Sekmeler/çekmece öğeleri arasında geçiş yaparken mevcut sayfayı koru',
    ],

    // Sidebar
    'sidebar' => [
        'app_settings' => 'Uygulama ayarları',
        'general' => 'Genel',
        'design' => 'Tasarım',
        'icon' => 'Simge',
        'splashscreen' => 'Açılış Ekranı',
        'navigation' => 'Navigasyon',
        'drawer' => 'Çekmece',
        'webview' => 'WebView',
        'permissions' => 'İzinler',
        'custom_code' => 'Özel Kod',
        'hosted_pages' => 'Barındırılan Sayfalar',
        'notifications' => 'Bildirimler',
        'deployment' => 'Dağıtım',
        'builds' => 'Derlemeler',
        'signing' => 'İmzalama',
        'back_to_apps' => 'Uygulamalara Dön',
    ],

    // WebView Settings
    'webview_user_agent_title' => 'Kullanıcı Aracısı',
    'webview_user_agent_description' => 'Tarayıcı kullanıcı aracısı dizesini özelleştirin',
    'webview_custom_user_agent' => 'Özel Kullanıcı Aracısı',
    'webview_user_agent_placeholder' => 'Varsayılan Android WebView kullanıcı aracısını kullanmak için boş bırakın',
    'webview_user_agent_helper' => 'İsteğe bağlı. Web sitenize gönderilen varsayılan kullanıcı aracısını geçersiz kılın.',
    'webview_features_title' => 'WebView Özellikleri',
    'webview_features_description' => 'Tarayıcı yeteneklerini ve davranışını yapılandırın',
    'webview_enable_javascript' => 'JavaScript\'i Etkinleştir',
    'webview_enable_javascript_description' => 'WebView\'da JavaScript yürütülmesine izin ver',
    'webview_enable_dom_storage' => 'DOM Depolamayı Etkinleştir',
    'webview_enable_dom_storage_description' => 'localStorage ve sessionStorage API\'lerine izin ver',
    'webview_enable_zoom_controls' => 'Yakınlaştırma Kontrollerini Etkinleştir',
    'webview_enable_zoom_controls_description' => 'Parmakla yakınlaştırma ve yakınlaştırma kontrollerine izin ver',
    'webview_enable_cache' => 'Önbelleği Etkinleştir',
    'webview_enable_cache_description' => 'Daha hızlı yükleme için web içeriğini önbelleğe al',

    // Permissions Settings
    'permissions_location_title' => 'Konum İzni',
    'permissions_location_description' => 'Konum tabanlı özellikler için cihaz GPS\'ine eriş',
    'permissions_enable_location' => 'Konum Erişimini Etkinleştir',
    'permissions_location_helper' => 'Haritalar, konum tabanlı içerik ve coğrafi sınırlama özellikleri için gerekli.',
    'permissions_show_code_example' => 'Kod örneğini göster',
    'permissions_hide_code_example' => 'Kod örneğini gizle',
    'permissions_javascript_example' => 'JavaScript Örneği:',
    'permissions_camera_title' => 'Kamera İzni',
    'permissions_camera_description' => 'Fotoğraf ve video için cihaz kamerasına eriş',
    'permissions_enable_camera' => 'Kamera Erişimini Etkinleştir',
    'permissions_camera_helper' => 'Fotoğraf çekme, QR kod tarama ve görüntülü aramalar için gerekli.',
    'permissions_storage_title' => 'Depolama İzni',
    'permissions_storage_description' => 'Dosya yüklemeleri ve indirmeleri için cihaz depolamasına eriş',
    'permissions_enable_storage' => 'Depolama Erişimini Etkinleştir',
    'permissions_storage_helper' => 'Dosya yüklemeleri, görsel seçici ve dosya indirme için gerekli.',
    'permissions_microphone_title' => 'Mikrofon İzni',
    'permissions_microphone_description' => 'Ses kaydı için cihaz mikrofonuna eriş',
    'permissions_enable_microphone' => 'Mikrofon Erişimini Etkinleştir',
    'permissions_microphone_helper' => 'Ses kaydı, sesli aramalar ve konuşma tanıma için gerekli.',
    'permissions_contacts_title' => 'Kişiler İzni',
    'permissions_contacts_description' => 'Sosyal özellikler için cihaz kişilerine eriş',
    'permissions_enable_contacts' => 'Kişiler Erişimini Etkinleştir',
    'permissions_contacts_helper' => 'Kişi seçici, davet özellikleri ve sosyal entegrasyonlar için gerekli.',
    'permissions_vibrate_title' => 'Titreşim İzni',
    'permissions_vibrate_description' => 'Dokunsal geri bildirim için cihaz titreşim motoruna eriş',
    'permissions_enable_vibrate' => 'Titreşimi Etkinleştir',
    'permissions_vibrate_helper' => 'Dokunsal geri bildirim ve bildirim titreşimleri için gerekli.',

    // Custom Code Settings
    'custom_code_access_required_title' => 'Yükseltme Gerekli',
    'custom_code_access_required_description' => 'Mevcut planınız özel kod eklemeyi içermiyor. Bu özelliğe erişmek ve uygulamanıza özel CSS ve JavaScript eklemek için yükseltin.',
    'custom_code_upgrade_plan' => 'Planınızı yükseltin',
    'custom_code_enable_feature' => 'bu özelliği etkinleştirmek için.',
    'custom_code_css_title' => 'Özel CSS',
    'custom_code_css_description' => 'Uygulama görünümünüzü kişiselleştirmek için özel stiller ekleyin',
    'custom_code_css_label' => 'CSS Kodu',
    'custom_code_css_helper' => 'Maksimum 100KB. CSS her sayfaya enjekte edilecektir.',
    'custom_code_js_title' => 'Özel JavaScript',
    'custom_code_js_description' => 'Genişletilmiş işlevsellik için özel scriptler ekleyin',
    'custom_code_js_label' => 'JavaScript Kodu',
    'custom_code_js_helper' => 'Maksimum 100KB. JavaScript webview\'da yürütülecektir.',

    // Notifications Settings
    'notifications_title' => 'Bildirimler',
    'notifications_description' => 'Bildirimler için Firebase Cloud Messaging (FCM) yapılandırın',
    'notifications_enable' => 'Bildirimleri Etkinleştir',
    'notifications_firebase_service_account' => 'Firebase Hizmet Hesabı',
    'notifications_firebase_service_account_description' => 'Sunucu tarafından FCM API üzerinden bildirim göndermek için kullanılır',
    'notifications_firebase_help_text' => 'JSON dosyası (MAKS. 2MB)',
    'notifications_delete_firebase_credentials' => 'Firebase Kimlik Bilgilerini Sil',
    'notifications_delete_firebase_credentials_confirm' => 'Firebase kimlik bilgileri dosyasını silmek istediğinizden emin misiniz?',
    'notifications_google_services' => 'Google Services',
    'notifications_google_services_description' => 'Android uygulama yapılandırması için gerekli',
    'notifications_google_services_help_text' => 'JSON dosyası (MAKS. 1MB)',
    'notifications_delete_google_services' => 'Google Services Dosyasını Sil',
    'notifications_delete_google_services_confirm' => 'Google Services dosyasını silmek istediğinizden emin misiniz?',

    // Signing Keys Settings
    'signing_keys' => [
        'android_keystores' => 'Android Keystore\'lar',
        'generate_new' => 'Yeni Oluştur',
        'upload_existing' => 'Mevcut Yükle',
        'default_badge' => 'Varsayılan',
        'alias' => 'Takma Ad',
        'alias_placeholder' => 'anahtar-takma-adim',
        'auto_generated' => 'Otomatik oluşturuldu',
        'created' => 'Oluşturuldu',
        'set_as_default' => 'Varsayılan Yap',
        'edit' => 'Düzenle',
        'delete' => 'Sil',
        'no_keystores' => 'Henüz Android keystore yok. Yeni bir anahtar oluşturun veya mevcut bir tane yükleyin.',
        'upload_signing_key' => 'İmzalama Anahtarı Yükle',
        'android_keystore_upload' => 'Android Keystore Yükleme',
        'keystore_name' => 'Keystore Adı',
        'keystore_name_placeholder' => 'Yayın Keystore\'um',
        'keystore_file' => 'Keystore Dosyası',
        'keystore_file_help' => '.jks, .keystore veya .ks dosyası (Maks 5MB)',
        'upload_custom_key' => 'Özel anahtar yükle',
        'upload_custom_key_help' => 'Otomatik oluşturulan debug keystore kullanıyorsanız bunu işaretlemeyin',
        'password' => 'Şifre',
        'password_placeholder' => '••••••••',
        'password_help' => 'Hem keystore hem de anahtar erişimi için kullanılır',
        'cancel' => 'İptal',
        'upload' => 'Yükle',
        'edit_keystore' => 'Keystore\'u Düzenle',
        'update_password' => 'Şifreyi güncelle',
        'save' => 'Kaydet',
        'delete_keystore' => 'Keystore\'u Sil',
        'delete_confirmation' => 'Silmek istediğinizden emin misiniz',
        'action_cannot_be_undone' => 'Bu işlem geri alınamaz.',

        // Keystore Generator Modal
        'generate_signing_key' => 'İmzalama Anahtarı Oluştur',
        'generate_android_keystore' => 'Android Keystore Oluştur',
        'generate_keystore_description' => 'Derleme sunucusunda güvenli bir şekilde yeni bir JKS keystore oluşturulacak',
        'keystore_name_generate_placeholder' => 'Uygulama Yayın Anahtarım',
        'key_alias' => 'Anahtar Takma Adı',
        'key_alias_placeholder' => 'uygulama-anahtarim',
        'key_alias_help' => 'Bir harfle başlamalıdır. Harf, rakam, tire ve alt çizgi kullanılabilir.',
        'password_settings' => 'Şifre Ayarları',
        'keystore_password' => 'Keystore Şifresi',
        'min_characters_placeholder' => 'Min. 6 karakter',
        'use_same_password' => 'Anahtar ve keystore için aynı şifreyi kullan',
        'key_password' => 'Anahtar Şifresi',
        'validity_period' => 'Geçerlilik Süresi',
        'years_10' => '10 yıl',
        'years_15' => '15 yıl',
        'years_20' => '20 yıl',
        'years_25_recommended' => '25 yıl (Önerilen)',
        'years_30' => '30 yıl',
        'validity_help' => 'Google Play yeni uygulamalar için en az 25 yıl geçerlilik gerektirir',
        'certificate_details' => 'Sertifika Detayları (İsteğe Bağlı)',
        'common_name' => 'Ortak Ad (CN)',
        'common_name_placeholder' => 'Uygulamanız veya kuruluş adınız',
        'organization' => 'Kuruluş (O)',
        'organization_placeholder' => 'Şirket Adı',
        'organizational_unit' => 'Kuruluş Birimi (OU)',
        'organizational_unit_placeholder' => 'Mobil Uygulamalar',
        'city' => 'Şehir (L)',
        'city_placeholder' => 'İstanbul',
        'state' => 'İl (ST)',
        'state_placeholder' => 'İstanbul',
        'country' => 'Ülke (C)',
        'country_placeholder' => 'TR',
        'save_password_warning' => 'Önemli: Şifrenizi güvenli bir yerde saklayın!',
        'save_password_description' => 'Keystore şifrelenecek ve saklanacaktır. Gelecek derlemeler için şifreye ihtiyacınız olacak. Kayıp şifreyi kurtarmanın bir yolu yok.',
        'generating' => 'Oluşturuluyor...',
        'generate_keystore' => 'Keystore Oluştur',
    ],

    // Hosted Pages Settings
    'hosted_pages' => [
        'access_required' => 'Barındırılan Sayfa Erişimi Gerekli',
        'upgrade_description' => 'Mevcut planınız barındırılan sayfaları içermiyor. Tarafımızca barındırılan özel sayfalar oluşturmak için planınızı yükseltin.',
        'upgrade_plan' => 'Planınızı yükseltin',
        'upgrade_suffix' => 'bu özelliği etkinleştirmek için.',
        'table_page' => 'Sayfa',
        'table_status' => 'Durum',
        'table_created' => 'Oluşturuldu',
        'table_actions' => 'İşlemler',
        'status_published' => 'Yayında',
        'status_draft' => 'Taslak',
        'edit' => 'Düzenle',
        'delete' => 'Sil',
        'no_pages' => 'Henüz sayfa yok',
        'no_pages_description' => 'İlk barındırılan sayfanızı oluşturmak için "Sayfa Ekle"ye tıklayın.',
    ],

    // Hosted Page Editor Modal
    'hosted_page_editor' => [
        'create_page' => 'Sayfa Oluştur',
        'edit_page' => 'Sayfayı Düzenle',
        'title' => 'Başlık',
        'title_placeholder' => 'Sayfa başlığı',
        'slug' => 'Slug',
        'slug_placeholder' => 'sayfa-slug',
        'start_from_template' => 'Şablondan başla',
        'status' => 'Durum',
        'status_help' => 'Sadece yayında olan sayfalar uygulamada erişilebilir',
        'cancel' => 'İptal',
        'save_changes' => 'Değişiklikleri Kaydet',
    ],

    // WordPress-specific Settings
    'wordpress' => [
        // General Settings
        'app_name_placeholder' => 'WordPress Uygulamam',
        'wordpress_site_url' => 'WordPress Site URL\'si',
        'wordpress_site_url_placeholder' => 'https://blogum.wordpress.com',
        'wordpress_site_url_help' => 'WordPress.com site URL\'nizi girin (örn., blogum.wordpress.com)',
        'app_id_placeholder' => 'com.ornek.wordpress',
        'package_name_help' => 'Ters alan formatında benzersiz tanımlayıcı (örn., com.sirket.wordpress). Oluşturulduktan sonra değiştirilemez.',

        // Design Settings
        'post_list_style' => 'Gönderi Listesi Stili',
        'style_list' => 'Liste',
        'style_grid' => 'Izgara',
        'style_magazine' => 'Dergi',
        'post_list_style_help' => 'Gönderilerin uygulamada nasıl görüntüleneceği',
        'progress_indicator_help' => 'Gönderiler alınırken gösterilen yükleme göstergesi stili',
        'show_app_bar_title' => 'Uygulama çubuğunda uygulama adını göster',
        'show_app_bar_title_help' => 'Üst çubukta uygulamanızın adını görüntüle',
        'nav_tab_icon_colors_help' => 'Aktif olmayan sekme simgelerinin rengi',
        'active_tab_colors_help' => 'Seçili sekmenin rengi',
        'theme_color_help' => 'Uygulamanız boyunca kullanılan ana renk (WordPress mavisi: #21759B)',
        'dynamic_colors_help' => 'Etkinleştirildiğinde, uygulamanız Android 12+ cihazlarda kullanıcının duvar kağıdından renklere uyum sağlar.',
        'layout_list_only' => 'Sadece Liste',

        // Splashscreen Settings
        'splashscreen_title_placeholder' => 'WordPress Uygulamam',
        'splashscreen_subtitle_placeholder' => 'En iyi blog uygulamasına hoş geldiniz',

        // Sidebar
        'content' => 'İçerik',
        'features' => 'Özellikler',

        // Drawer Settings
        'drawer_appearance_description' => 'Navigasyon çekmecesi arka planını özelleştirin',
        'drawer_branding_description' => 'Logo, başlık ve metin stili',
        'logo_light_mode' => 'Logo (Açık Mod)',
        'logo_dark_mode' => 'Logo (Koyu Mod)',
        'png_transparency_help' => 'Şeffaf PNG (MAKS. 2MB)',
        'delete_background' => 'Arka Planı Sil',
        'drawer_title_placeholder' => 'WordPress Uygulamam',
        'drawer_subtitle_placeholder' => 'Sloganınız burada',
        'item_colors_description' => 'Menü öğeleri için simge ve metin renkleri',
        'inactive_item_colors' => 'Aktif Olmayan Öğe Renkleri',

        // Navigation Settings
        'bottom_nav_tabs' => 'Alt Navigasyon Sekmeleri',
        'bottom_nav_tabs_description' => 'Alt navigasyon öğelerini yapılandırın (maks 8 + ana)',
        'add_tab' => '+ Sekme Ekle',
        'home_tab_shows_all_posts' => 'Ana Sekme - Tüm Gönderileri Gösterir',
        'home_item_shows_all_posts' => 'Ana Öğe - Tüm Gönderileri Gösterir',
        'tab_name_placeholder' => 'Sekme Adı',
        'menu_item_placeholder' => 'Menü Öğesi',
        'action_category' => 'Kategori',
        'action_tag' => 'Etiket',
        'action_search' => 'Ara',
        'action_bookmarks' => 'Yer İmleri',
        'action_share' => 'Paylaş',
        'category_slug' => 'Kategori Slug',
        'tag_slug' => 'Etiket Slug',
        'category_slug_placeholder' => 'teknoloji',
        'tag_slug_placeholder' => 'one-cikan',
        'app_bar_buttons_description' => 'Sağ üstte eylem düğmeleri (maks 3)',
        'no_app_bar_buttons_description' => 'Uygulama çubuğu düğmesi yapılandırılmadı. Arama, paylaşma veya diğer hızlı eylemler ekleyin.',
        'search_placeholder' => 'Ara',
        'drawer_menu_items_description' => 'Navigasyon çekmecesi menü öğeleri (1 ana + 9 öğe)',
        'swipe_navigation_description' => 'Kenardan kaydırarak geri git',
        'preserve_tab_state_description' => 'Sekmeler arasında geçiş yaparken kaydırma konumunu koru',

        // Content Settings
        'post_display' => 'Gönderi Görünümü',
        'post_display_description' => 'Gönderilerin uygulamanızda nasıl görüntüleneceğini yapılandırın',
        'posts_per_page' => 'Sayfa Başına Gönderi',
        'posts_per_page_help' => 'Bir seferde yüklenecek gönderi sayısı (1-50)',
        'excerpt_length' => 'Özet Uzunluğu (karakter)',
        'excerpt_length_help' => 'Gönderi özetlerinde gösterilen maksimum karakter (50-500)',
        'post_metadata' => 'Gönderi Meta Verileri',
        'post_metadata_description' => 'Her gönderi ile birlikte hangi bilgilerin gösterileceğini seçin',
        'show_featured_image' => 'Öne çıkan görseli göster',
        'show_featured_image_help' => 'Gönderinin öne çıkan/küçük resim görselini görüntüle',
        'show_excerpt' => 'Gönderi özetini göster',
        'show_excerpt_help' => 'Gönderi içeriğinin bir önizlemesini görüntüle',
        'show_author' => 'Yazar adını göster',
        'show_author_help' => 'Gönderiyi yazan yazarı görüntüle',
        'show_date' => 'Yayın tarihini göster',
        'show_date_help' => 'Gönderinin ne zaman yayınlandığını görüntüle',
        'show_categories' => 'Kategorileri göster',
        'show_categories_help' => 'Gönderiye atanan kategorileri görüntüle',
        'show_reading_time' => 'Tahmini okuma süresini göster',
        'show_reading_time_help' => 'Gönderiyi okumanın ne kadar süreceğini görüntüle',

        // Features Settings
        'core_features' => 'Temel Özellikler',
        'core_features_description' => 'Uygulama işlevselliğini etkinleştirin veya devre dışı bırakın',
        'enable_search' => 'Aramayı etkinleştir',
        'enable_search_help' => 'Kullanıcıların uygulamanızda gönderi aramasına izin ver',
        'enable_comments' => 'Yorumları etkinleştir',
        'enable_comments_help' => 'Kullanıcıların makalelerde yorum görüntülemesine ve yorum yapmasına izin ver',
        'enable_bookmarks' => 'Yer imlerini etkinleştir',
        'enable_bookmarks_help' => 'Kullanıcıların gönderileri daha sonra okumak için kaydetmesine izin ver',
        'enable_share' => 'Paylaşımı etkinleştir',
        'enable_share_help' => 'Kullanıcıların gönderileri diğer uygulamalar aracılığıyla paylaşmasına izin ver',
        'advanced_features' => 'Gelişmiş Özellikler',
        'advanced_features_description' => 'Gelişmiş kullanıcı deneyimi için ek işlevsellik',
        'enable_offline_reading' => 'Çevrimdışı okumayı etkinleştir',
        'enable_offline_reading_help' => 'İnternet bağlantısı olmadan okumak için gönderileri önbelleğe al',
        'enable_user_auth' => 'Kullanıcı kimlik doğrulamasını etkinleştir',
        'enable_user_auth_help' => 'Kullanıcıların WordPress.com hesaplarıyla giriş yapmasına izin ver',
        'enable_push_notifications' => 'Push bildirimlerini etkinleştir',
        'enable_push_notifications_help' => 'Yeni gönderiler yayınlandığında bildirim gönder',
    ],

    // Builds
    'builds' => [
        // Builds Table
        'search_placeholder' => 'Derleme ara...',
        'filter' => 'Filtrele',
        'platform_filter' => 'Platform',
        'status_filter' => 'Durum',
        'android' => 'Android',
        'completed' => 'Tamamlandı',
        'building' => 'Derleniyor',
        'failed' => 'Başarısız',
        'pending' => 'Beklemede',
        'table_platform' => 'Platform',
        'table_build_info' => 'Derleme Bilgisi',
        'table_created' => 'Oluşturuldu',
        'table_actions' => 'İşlemler',
        'release' => 'Yayın',
        'debug' => 'Hata Ayıklama',
        'download' => 'İndir',
        'preview' => 'Önizleme',
        'logs' => 'Günlükler',
        'delete' => 'Sil',
        'no_builds' => 'Derleme bulunamadı',

        // Build Modal
        'create_new_build' => 'Yeni Derleme Oluştur',
        'platform_label' => 'Platform',
        'build_costs_credit' => 'Derleme :count kredi maliyetinde',
        'build_type_label' => 'Derleme Türü',
        'for_testing' => 'Test için',
        'for_production' => 'Üretim için',
        'output_format_label' => 'Çıktı Formatı',
        'apk' => 'APK',
        'aab' => 'AAB',
        'for_testing_sideloading' => 'Test/yan yükleme için',
        'for_google_play_store' => 'Google Play Store için',
        'builder_label' => 'Derleyici',
        'auto_select_recommended' => 'Otomatik seç (önerilen)',
        'auto_select_help' => 'En az meşgul derleyiciyi kullanmak için "Otomatik seç" olarak bırakın veya belirli bir derleyici seçin.',
        'no_builders_available' => 'Kullanılabilir derleyici yok!',
        'no_builders_help' => 'Planınızın herhangi bir derleyiciye erişimi yok. Lütfen destek ile iletişime geçin veya planınızı yükseltin.',
        'signing_key_label' => 'İmzalama Anahtarı',
        'select_keystore' => 'Bir keystore seçin',
        'no_keystores_available' => 'Kullanılabilir keystore yok.',
        'upload_in_signing_section' => 'İmzalama bölümüne bir tane yükleyin',
        'signing_key_required' => 'İmzalama anahtarı gerekli!',
        'version_name_label' => 'Sürüm Adı',
        'version_name_help' => 'Format: X.Y veya X.Y.Z (örn., 1.0 veya 1.0.0). Her platform için otomatik artırılır.',
        'build_number_label' => 'Derleme Numarası',
        'next_build_number' => 'Sonraki Derleme Numarası',
        'build_number_auto_increment' => 'Derleme numarası her derlemede otomatik olarak artırılır',
        'build_cost_info' => 'Bu derleme :count kredi maliyetinde olacak',
        'build_email_notification' => 'Derleme indirilmeye hazır olduğunda e-posta alacaksınız.',
        'cancel' => 'İptal',
        'start_build' => 'Derlemeyi Başlat',
        'credit' => 'kredi',
        'credits' => 'kredi',
        'builder_info' => 'Derleyici:',

        // Build Logs Modal
        'build_logs' => 'Derleme Günlükleri',
        'duration' => 'Süre:',
        'no_logs_available' => 'Bu derleme için günlük mevcut değil',
        'error' => 'Hata:',
        'close' => 'Kapat',
        'download_build' => 'Derlemeyi İndir',

        // Build Download Modal
        'download_build_title' => 'Derlemeyi İndir',
        'aab_title' => 'Android App Bundle (AAB)',
        'aab_description' => 'Bu bir AAB dosyasıdır ve cihazlara doğrudan yüklenemez. AAB dosyaları Google Play Console\'a yüklenmek için tasarlanmıştır, burada Google kullanıcılar için optimize edilmiş APK\'lar oluşturacaktır.',
        'scan_with_android' => 'Android cihazınızla tarayın',
        'qr_unavailable' => 'QR kod mevcut değil',
        'download_options' => 'İndirme Seçenekleri',
        'download_options_description' => 'QR kodu mobil cihazınızla tarayın veya aşağıdaki doğrudan indirme bağlantısını kullanın.',
        'download_format' => ':format İndir',
        'installation_note' => 'Kurulum:',
        'installation_help' => 'Android ayarlarınızda "Bilinmeyen Kaynaklardan Yükle"yi etkinleştirmeniz gerekebilir.',
        'download_aab_file' => 'AAB Dosyasını İndir',
        'upload_to_play_console' => 'Uygulamanızı yayınlamak için bu dosyayı Google Play Console\'a yükleyin.',
        'next_steps' => 'Sonraki Adımlar:',
        'next_steps_help' => 'Bu AAB dosyasını Google Play Console\'a Yayın > Üretim/Test bölümüne yükleyin. Google kullanıcılarınız için otomatik olarak optimize edilmiş APK\'lar oluşturacaktır.',

        // Delete Build Modal
        'delete_build' => 'Derlemeyi Sil',
        'delete_confirmation' => 'Silmek istediğinizden emin misiniz',
        'build_suffix' => 'derlemesini?',
        'action_cannot_be_undone' => 'Bu işlem geri alınamaz.',
    ],

    // App Preview Panel
    'preview' => [
        'no_build_selected' => 'Derleme Seçilmedi',
        'select_build_help' => 'Burada önizlemek için Derlemeler sekmesinden tamamlanmış bir derleme seçin',
    ],

    // App Creation Form
    'creation' => [
        'website_url' => 'Web Sitesi URL\'si',
        'app_id' => 'UYGULAMA ID',
        'app_id_tooltip' => 'Benzersiz paket tanımlayıcı (oluşturulduktan sonra değiştirilemez)',
        'auto_generate_package' => 'Uygulama adından otomatik oluştur',
        'package_name_help' => 'Ters alan formatında benzersiz tanımlayıcı (örn., com.sirket.uygulama). Oluşturulduktan sonra değiştirilemez.',
        'theme_color' => 'Tema Rengi',
        'theme_color_help' => 'Uygulamanız boyunca kullanılan ana renk. Metin renkleri varsayılan siyah/beyaz kullanacak ve daha sonra özelleştirilebilir.',
        'layout_template' => 'Düzen şablonu',
        'layout_app_bar_drawer' => 'Uygulama Çubuğu + Çekmece',
        'layout_app_bar_tabs' => 'Uygulama Çubuğu + Navigasyon Sekmeleri',
        'layout_app_bar' => 'Uygulama Çubuğu',
        'layout_blank' => 'Boş',
        'layout_help' => 'Uygulamanız için navigasyon yapısını seçin',
    ],

    // Delete Modals
    'modals' => [
        'cancel' => 'İptal',
        'delete' => 'Sil',
        'action_cannot_be_undone' => 'Bu işlem geri alınamaz.',
        'delete_build' => 'Derlemeyi Sil',
        'delete_build_confirmation' => 'Silmek istediğinizden emin misiniz',
        'build_suffix' => 'derlemesini?',
        'delete_app_icon' => 'Uygulama Simgesini Sil',
        'delete_icon_confirmation' => 'Simgesini silmek istediğinizden emin misiniz',
        'delete_keystore' => 'Keystore\'u Sil',
        'delete_keystore_confirmation' => 'Silmek istediğinizden emin misiniz',
        'delete_splashscreen_background' => 'Açılış Ekranı Arka Planını Sil',
        'delete_splashscreen_background_confirmation' => 'Açılış ekranı arka plan görselini silmek istediğinizden emin misiniz',
        'delete_splashscreen_logo' => 'Açılış Ekranı Logosunu Sil',
        'delete_splashscreen_logo_confirmation' => 'Açılış ekranı logosunu silmek istediğinizden emin misiniz',
        'delete_drawer_background' => 'Çekmece Arka Planını Sil',
        'delete_drawer_background_confirmation' => 'Çekmece arka plan görselini silmek istediğinizden emin misiniz',
        'delete_dark_mode_logo' => 'Koyu Mod Logosunu Sil',
        'delete_dark_mode_logo_confirmation' => 'Çekmece koyu mod logosunu silmek istediğinizden emin misiniz',
        'delete_light_mode_logo' => 'Açık Mod Logosunu Sil',
        'delete_light_mode_logo_confirmation' => 'Çekmece açık mod logosunu silmek istediğinizden emin misiniz',
        'delete_page' => 'Sayfayı Sil',
        'delete_page_confirmation' => 'Silmek istediğinizden emin misiniz',
        'delete_page_warning' => 'Bu işlem geri alınamaz. Bu sayfa navigasyonunuzda kullanılıyorsa, artık erişilebilir olmayacaktır.',
    ],

    // WordPress Notifications Settings
    'notifications_wp' => [
        'title' => 'Push Bildirimleri',
        'description' => 'Push bildirimleri için Firebase Cloud Messaging yapılandırın',
        'enable_label' => 'Push bildirimlerini etkinleştir',
        'enable_help' => 'Yeni gönderiler yayınlandığında bildirim gönder',
        'firebase_required_title' => 'Firebase Yapılandırması Gerekli',
        'firebase_required_description' => 'Uygulamanızda push bildirimlerini etkinleştirmek için aşağıdaki her iki yapılandırma dosyasını da yükleyin.',
        'google_services_label' => 'google-services.json',
        'file_uploaded' => 'Dosya yüklendi',
        'google_services_configured' => 'google-services.json yapılandırıldı',
        'delete' => 'Sil',
        'delete_file_confirm' => 'Bu dosyayı silmek istediğinizden emin misiniz?',
        'upload_google_services' => 'google-services.json yükle',
        'google_services_help' => 'Firebase Console\'dan indirin (MAKS. 1MB)',
        'google_services_instructions' => 'Firebase Console > Proje Ayarları > Uygulamalarınız > Android uygulaması\'ndan indirin',
        'firebase_service_account_label' => 'Firebase Hizmet Hesabı (bildirim göndermek için)',
        'credentials_configured' => 'Kimlik bilgileri yapılandırıldı',
        'service_account_stored' => 'Hizmet hesabı güvenli bir şekilde saklanıyor',
        'delete_credentials_confirm' => 'Bu kimlik bilgilerini silmek istediğinizden emin misiniz?',
        'upload_service_account' => 'Hizmet Hesabı JSON Yükle',
        'service_account_help' => 'Firebase Console\'dan indirin (MAKS. 2MB)',
        'service_account_instructions' => 'Firebase Console > Proje Ayarları > Hizmet Hesapları > Yeni özel anahtar oluştur\'dan indirin',
        'setup_title' => 'Firebase nasıl kurulur:',
        'setup_step_1' => 'Şuraya gidin',
        'setup_step_2' => 'Bir proje oluşturun veya mevcut birini seçin',
        'setup_step_3' => 'Paket adınızla bir Android uygulaması ekleyin:',
        'setup_step_4' => 'İndirin',
        'setup_step_4_suffix' => 've yukarıya yükleyin',
        'setup_step_5' => 'Proje Ayarları > Hizmet Hesapları\'na gidin',
        'setup_step_6' => 'Yeni bir özel anahtar oluşturun ve yukarıya yükleyin',
    ],

    // Toast Messages - Settings
    'toast' => [
        // General success/error
        'settings_saved' => ':section ayarları başarıyla kaydedildi!',
        'settings_save_failed' => 'Ayarlar kaydedilemedi. Lütfen tekrar deneyin.',

        // Design settings
        'design_saved' => 'Tasarım ayarları başarıyla kaydedildi!',

        // Navigation settings
        'navigation_saved' => 'Navigasyon ayarları başarıyla kaydedildi!',
        'home_tab_cannot_delete' => 'Ana sekme silinemez. Navigasyon için gereklidir.',
        'home_tab_cannot_move' => 'Ana sekme ilk sırada kalmalıdır ve taşınamaz.',
        'cannot_move_below_home' => 'Öğeler ana sekmenin altına taşınamaz.',
        'home_item_cannot_delete' => 'Ana öğe silinemez. Navigasyon için gereklidir.',
        'home_item_cannot_move' => 'Ana öğe ilk sırada kalmalıdır ve taşınamaz.',
        'cannot_move_below_home_item' => 'Öğeler ana öğenin altına taşınamaz.',

        // Custom code
        'custom_code_saved' => 'Özel kod başarıyla kaydedildi!',
        'custom_code_save_failed' => 'Özel kod kaydedilemedi. Lütfen tekrar deneyin.',
        'custom_code_no_access' => 'Planınız özel kod erişimi içermiyor. Lütfen planınızı yükseltin.',

        // WebView settings
        'webview_saved' => 'WebView ayarları başarıyla kaydedildi!',

        // Permissions settings
        'permissions_saved' => 'İzinler başarıyla kaydedildi!',

        // Drawer settings
        'drawer_saved' => 'Çekmece ayarları başarıyla kaydedildi!',

        // General settings
        'general_saved' => 'Genel ayarlar başarıyla kaydedildi!',

        // Splashscreen settings
        'splashscreen_saved' => 'Açılış ekranı ayarları başarıyla kaydedildi!',

        // Icon settings
        'icon_uploaded' => 'Uygulama simgesi başarıyla yüklendi!',
        'icon_upload_failed' => 'Simge yüklenemedi: :error',
        'icon_removed' => 'Uygulama simgesi başarıyla kaldırıldı!',
        'icon_remove_failed' => 'Simge kaldırılamadı. Lütfen tekrar deneyin.',

        // Splashscreen modals
        'splashscreen_background_deleted' => 'Açılış ekranı arka plan görseli başarıyla silindi!',
        'splashscreen_background_delete_failed' => 'Arka plan görseli silinemedi. Lütfen tekrar deneyin.',
        'splashscreen_logo_deleted' => 'Açılış ekranı logosu başarıyla silindi!',
        'splashscreen_logo_delete_failed' => 'Logo silinemedi. Lütfen tekrar deneyin.',

        // Drawer modals
        'drawer_background_deleted' => 'Çekmece arka plan görseli başarıyla silindi!',
        'drawer_background_delete_failed' => 'Arka plan görseli silinemedi. Lütfen tekrar deneyin.',
        'drawer_logo_deleted' => 'Çekmece logosu başarıyla silindi!',
        'drawer_logo_delete_failed' => 'Logo silinemedi. Lütfen tekrar deneyin.',
        'drawer_logo_light_deleted' => 'Çekmece açık mod logosu başarıyla silindi!',
        'drawer_logo_dark_deleted' => 'Çekmece koyu mod logosu başarıyla silindi!',

        // Notifications settings
        'notifications_saved' => 'Bildirim ayarları başarıyla kaydedildi!',
        'firebase_credentials_deleted' => 'Firebase kimlik bilgileri başarıyla silindi!',
        'firebase_credentials_delete_failed' => 'Firebase kimlik bilgileri silinemedi. Lütfen tekrar deneyin.',
        'google_services_deleted' => 'Google Services dosyası başarıyla silindi!',
        'google_services_delete_failed' => 'Google Services dosyası silinemedi. Lütfen tekrar deneyin.',

        // Signing keys
        'keystore_updated' => 'Keystore başarıyla güncellendi!',
        'keystore_update_failed' => 'Keystore güncellenemedi.',
        'keystore_load_failed' => 'Keystore yüklenemedi.',
        'keystore_deleted' => 'Keystore başarıyla silindi!',
        'keystore_delete_failed' => 'Keystore silinemedi. Lütfen tekrar deneyin.',
        'keystore_uploaded' => 'Keystore başarıyla yüklendi!',
        'keystore_upload_failed' => 'İmzalama anahtarı yüklenemedi: :error',
        'keystore_generated' => 'Keystore başarıyla oluşturuldu!',
        'keystore_set_default' => 'Varsayılan keystore başarıyla güncellendi!',

        // Build modal
        'build_no_builders_platform' => ':platform platformu için kullanılabilir derleyici yok. Lütfen destek ile iletişime geçin veya planınızı yükseltin.',
        'build_no_subscription' => 'Uygulama derlemek için aktif bir aboneliğe ihtiyacınız var. Lütfen bir plana abone olun.',
        'build_no_builders_plan' => 'Planınız için kullanılabilir derleyici yok. Lütfen destek ile iletişime geçin veya planınızı yükseltin.',
        'build_builder_not_available' => 'Seçilen derleyici planınız için kullanılamıyor.',
        'build_builder_unavailable' => 'Seçilen derleyici şu anda kullanılamıyor.',
        'build_builder_no_platform' => 'Seçilen derleyici :platform platformunu desteklemiyor.',
        'build_insufficient_credits' => 'Yetersiz derleme kredisi. Bu derleme :count kredi gerektiriyor. Lütfen planınızı yükseltin veya aylık sıfırlamayı bekleyin.',
        'build_keystore_required' => 'Yayın derlemeleri için Android keystore gereklidir. Lütfen bir keystore seçin.',
        'build_keystore_invalid' => 'Geçersiz keystore seçildi.',
        'build_already_in_progress' => 'Bir :platform derlemesi zaten devam ediyor. Lütfen tamamlanmasını bekleyin.',
        'build_queued' => ':platform derlemesi başarıyla kuyruğa alındı! Derleyici müsait olduğunda derlemeniz işlenecek. (:credits kredi kaldı)',
        'build_queued_on_builder' => ':platform derlemesi :builder üzerinde başarıyla kuyruğa alındı! (:credits kredi kaldı)',
        'build_create_failed' => 'Derleme oluşturulamadı: :error',
        'build_deleted' => 'Derleme başarıyla silindi!',
        'build_delete_failed' => 'Derleme silinemedi. Lütfen tekrar deneyin.',

        // Hosted pages
        'hosted_page_saved' => 'Sayfa başarıyla kaydedildi!',
        'hosted_page_save_failed' => 'Sayfa kaydedilemedi. Lütfen tekrar deneyin.',
        'hosted_page_deleted' => 'Sayfa başarıyla silindi!',
        'hosted_page_delete_failed' => 'Sayfa silinemedi. Lütfen tekrar deneyin.',
        'hosted_page_limit_reached' => 'Planınız için maksimum barındırılan sayfa sayısına ulaştınız.',
        'hosted_page_no_access' => 'Mevcut planınız barındırılan sayfaları içermiyor. Özel sayfalar oluşturmak için planınızı yükseltin.',

        // Additional toast keys for AndroidWordPress
        'features_saved' => 'Özellik ayarları başarıyla kaydedildi!',
        'content_saved' => 'İçerik ayarları başarıyla kaydedildi!',
        'storage_link_missing' => 'Depolama bağlantısı bulunamadı. Çalıştırın: php artisan storage:link',
        'splashscreen_image_deleted' => 'Açılış ekranı arka plan görseli başarıyla silindi!',
        'splashscreen_image_delete_failed' => 'Arka plan görseli silinemedi. Lütfen tekrar deneyin.',
        'logo_delete_failed' => 'Logo silinemedi. Lütfen tekrar deneyin.',
        'default_key_updated' => 'Varsayılan imzalama anahtarı başarıyla güncellendi!',
        'default_key_update_failed' => 'Varsayılan imzalama anahtarı güncellenemedi.',
        'keystore_uploaded_default' => 'Keystore yüklendi ve varsayılan olarak ayarlandı!',
        'signing_key_upload_failed' => 'İmzalama anahtarı yüklenemedi: :error',
        'page_not_found' => 'Sayfa bulunamadı.',
        'page_deleted' => 'Sayfa başarıyla silindi!',
        'page_delete_failed' => 'Sayfa silinemedi. Lütfen tekrar deneyin.',
        'page_updated' => 'Sayfa başarıyla güncellendi!',
        'page_created' => 'Sayfa başarıyla oluşturuldu!',
        'page_save_failed' => 'Sayfa kaydedilemedi. Lütfen tekrar deneyin.',
        'page_limit_reached' => 'Planınız için maksimum :max sayfaya ulaştınız.',
        'hosted_pages_not_available' => 'Planınız barındırılan sayfaları içermiyor. Lütfen planınızı yükseltin.',
        'unauthorized' => 'Yetkisiz işlem.',
        'home_tab_required' => 'Ana sekme silinemez. Navigasyon için gereklidir.',
        'home_tab_first' => 'Ana sekme ilk sırada kalmalıdır.',
        'home_item_required' => 'Ana öğe silinemez.',
        'build_no_builders' => ':platform platformu için kullanılabilir derleyici yok. Lütfen destek ile iletişime geçin veya planınızı yükseltin.',
        'build_no_plan_builders' => 'Planınız için kullanılabilir derleyici yok. Lütfen destek ile iletişime geçin veya planınızı yükseltin.',
        'build_builder_platform_unsupported' => 'Seçilen derleyici :platform platformunu desteklemiyor.',
        'build_insufficient_credits' => 'Yetersiz derleme kredisi. Bu derleme :credits kredi gerektiriyor. Lütfen planınızı yükseltin veya aylık sıfırlamayı bekleyin.',
        'build_invalid_keystore' => 'Geçersiz keystore seçildi.',
        'build_queued_no_builder' => ':platform derlemesi başarıyla kuyruğa alındı! Derleyici müsait olduğunda derlemeniz işlenecek. (:credits kredi kaldı)',
        'build_queued_success' => ':platform derlemesi :builder üzerinde başarıyla kuyruğa alındı! (:credits kredi kaldı)',
        'available_builder' => 'müsait derleyici',
        'invalid_google_services_json' => 'Geçersiz JSON dosyası. Lütfen geçerli bir google-services.json dosyası yükleyin.',
        'invalid_google_services_structure' => 'Geçersiz google-services.json. Gerekli project_info veya client bölümü eksik.',
        'invalid_firebase_service_account' => 'Geçersiz JSON dosyası. Lütfen geçerli bir Firebase hizmet hesabı dosyası yükleyin.',
        'invalid_firebase_service_account_type' => 'Geçersiz Firebase hizmet hesabı dosyası. Tür alanı eksik veya geçersiz.',
        'settings_save_failed_error' => 'Ayarlar kaydedilemedi: :error',
        'file_delete_failed' => 'Dosya silinemedi: :error',
        'credentials_delete_failed' => 'Kimlik bilgileri silinemedi: :error',
    ],

    // Editor Section Headers
    'sections' => [
        'general' => 'Genel',
        'general_description' => 'Temel bilgiler ve yapılandırma ayarları',
        'design' => 'Tasarım',
        'design_description' => 'Düzen, renk ve tema ayarlarını özelleştirin',
        'icon' => 'Simge',
        'icon_description' => 'Android için uygulama simgesi yükleyin',
        'splashscreen' => 'Açılış Ekranı',
        'splashscreen_description' => 'Başlangıç ekranı görünümü ve animasyonunu yapılandırın',
        'navigation' => 'Navigasyon',
        'navigation_description' => 'Navigasyon öğelerini ve uygulama çubuğu düğmelerini yönetin',
        'drawer' => 'Çekmece Ayarları',
        'drawer_description' => 'Çekmece menüsü görünümünü ve markalamasını özelleştirin',
        'webview' => 'WebView Ayarları',
        'webview_description' => 'WebView davranışını ve özelliklerini yapılandırın',
        'permissions' => 'İzinler',
        'permissions_description' => 'Uygulamanızın isteyeceği cihaz izinlerini yapılandırın',
        'custom_code' => 'Özel Kod',
        'custom_code_description' => 'Uygulamanıza özel CSS ve JavaScript enjekte edin',
        'hosted_pages' => 'Barındırılan Sayfalar',
        'hosted_pages_description' => 'Uygulamanız için tarafımızca barındırılan özel HTML sayfaları oluşturun',
        'pages' => 'Sayfalar',
        'add_page' => 'Sayfa Ekle',
        'notifications' => 'Bildirimler',
        'notifications_description' => 'Bildirimler için Firebase Cloud Messaging yapılandırın',
        'builds' => 'Derlemeler',
        'builds_description' => 'Dağıtım için Android APK ve AAB dosyaları oluşturun',
        'credits' => 'Krediler',
        'new_build' => 'Yeni Derleme',
        'signing' => 'İmzalama',
        'signing_description' => 'Uygulama dağıtımı için imzalama anahtarlarını yönetin',
        // WordPress-specific sections
        'general_description_wordpress' => 'Temel bilgiler ve WordPress site yapılandırması',
        'content' => 'İçerik',
        'content_description' => 'Gönderi görüntüleme ve içerik ayarlarını yapılandırın',
        'features' => 'Özellikler',
        'features_description' => 'Uygulama özelliklerini etkinleştirin veya devre dışı bırakın',
    ],

];
