<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Platform Plugin Translation Strings
    |--------------------------------------------------------------------------
    |
    | The following language lines are used by the platform plugin blade
    | templates for settings and configuration pages.
    |
    */

    // General Settings
    'general' => [
        'basic_information' => '기본 정보',
        'basic_information_description' => '앱에 대한 필수 정보',
        'app_name' => '앱 이름',
        'app_name_placeholder' => '나의 멋진 앱',
        'app_name_help' => '기기 홈 화면에 표시됩니다',
        'website_url' => '웹사이트 URL',
        'website_url_placeholder' => 'https://example.com',
        'website_url_help' => '웹사이트 또는 웹앱의 전체 URL',
        'configuration' => '설정',
        'configuration_description' => '기술 설정 및 식별자',
        'app_id' => 'APP ID',
        'app_id_tooltip' => '앱 스토어에서 사용하는 고유 패키지 식별자',
        'app_id_placeholder' => 'com.example.app',
        'app_id_help' => 'APP ID는 생성 후 변경할 수 없습니다',
        'copy' => '복사',
        'copied' => '복사됨!',
        'screen_orientation' => '화면 방향',
        'screen_orientation_help' => '기기에서 앱이 회전하는 방식을 제어합니다',
        'orientation_system' => '시스템',
        'orientation_portrait' => '세로',
        'orientation_landscape' => '가로',
        'app_language' => '앱 언어 (ISO 코드)',
        'app_language_help' => '앱 콘텐츠의 기본 언어',
    ],

    // Design Settings
    'design' => [
        'layout_template' => '레이아웃 템플릿',
        'layout_template_description' => '앱의 내비게이션 구조 선택',
        'layout_app_bar_drawer' => '앱 바 + 드로어',
        'layout_app_bar_tabs' => '앱 바 + 내비게이션 탭',
        'layout_app_bar' => '앱 바',
        'layout_blank' => '블랭크',
        'progress_indicator' => '진행 표시기',
        'progress_indicator_help' => '페이지 로딩 시 표시되는 로딩 인디케이터 스타일',
        'progress_disable' => '비활성화',
        'progress_linear' => '선형',
        'progress_circular' => '원형',
        'progress_indicator_color' => '진행 표시기 색상',
        'progress_indicator_color_help' => '로딩 진행 표시기의 색상',
        'show_app_bar_title' => '앱 바에 현재 웹페이지 제목 표시',
        'show_app_bar_title_help' => '상단 바에 현재 페이지의 제목을 표시합니다',
        'nav_tab_icon_colors' => '내비게이션 탭 아이콘 색상',
        'nav_tab_icon_colors_help' => '라이트 및 다크 모드에서 비활성 탭 아이콘의 색상',
        'active_tab_colors' => '활성 탭 색상',
        'active_tab_colors_help' => '라이트 및 다크 모드에서 선택된 탭의 색상',
        'light_mode' => '라이트 모드',
        'dark_mode' => '다크 모드',
        'theme_colors' => '테마 색상',
        'theme_colors_description' => '앱의 외관을 정의하는 기본 색상',
        'theme_color' => '테마 색상',
        'theme_color_help' => '앱 전체에서 사용되는 메인 색상',
        'enable_dynamic_colors' => 'Material You 동적 색상 활성화 (Android 12+)',
        'enable_dynamic_colors_help' => '활성화하면 Android 12+ 기기에서 사용자의 배경화면에서 색상을 적용합니다. 이 옵션은 위의 테마 색상을 재정의합니다.',
        'text_color_light' => '텍스트 색상 (라이트 모드)',
        'text_color_light_help' => '라이트 모드에서 기본 텍스트 및 아이콘 색상',
        'text_color_dark' => '텍스트 색상 (다크 모드)',
        'text_color_dark_help' => '다크 모드에서 기본 텍스트 및 아이콘 색상',
    ],

    // Icon Settings
    'icon' => [
        'app_icon' => '앱 아이콘',
        'app_icon_description' => 'icon.kitchen에서 ZIP 파일로 앱 아이콘을 업로드하세요',
        'current_icon' => '현재 아이콘',
        'icon_zip_uploaded' => '아이콘 ZIP 업로드됨',
        'icon_zip_uploaded_description' => '추출된 아이콘은 Android 및 웹 플랫폼에서 사용할 수 있습니다',
        'default_icon' => '기본 아이콘',
        'default_icon_description' => '기본값을 대체할 커스텀 아이콘을 업로드하세요',
        'delete' => '삭제',
        'upload_zip_file' => 'ZIP 파일 업로드',
        'upload_zip_help' => 'icon.kitchen의 ZIP 파일 (최대 10MB)',
        'how_to_create' => '아이콘 만드는 방법:',
        'step_visit' => '방문',
        'step_design' => '앱 아이콘 디자인',
        'step_download' => '모든 플랫폼 아이콘이 포함된 ZIP 파일 다운로드',
        'step_upload' => '여기에 ZIP 파일 업로드',
        'zip_file_info' => 'ZIP 파일에는 Android 및 웹 플랫폼용 아이콘이 포함되어야 합니다 (최대 10MB)',
        'upload_icon' => '아이콘 업로드',
    ],

    // Splashscreen Settings
    'splashscreen' => [
        'appearance' => '스플래시 화면 외관',
        'appearance_description' => '배경, 표시 시간, 애니메이션 효과 커스터마이징',
        'background_type' => '배경 유형',
        'background_type_color' => '단색',
        'background_type_image' => '배경 이미지',
        'background_color' => '배경색',
        'background_image' => '배경 이미지',
        'background_image_help' => 'PNG만 가능 (최대 2MB)',
        'delete_background_image' => '배경 이미지 삭제',
        'display_duration' => '표시 시간:',
        'seconds' => '초',
        'animation_effect' => '애니메이션 효과',
        'animation_fade' => '페이드',
        'animation_slide' => '슬라이드',
        'animation_zoom' => '줌',
        'animation_none' => '없음',
        'branding' => '스플래시 화면 브랜딩',
        'branding_description' => '스플래시 화면에 로고, 제목, 부제목, 텍스트 스타일링 추가',
        'show_logo' => '스플래시 화면에 로고 표시',
        'logo_image' => '로고 이미지',
        'logo_image_help' => '투명 배경 PNG 권장 (최대 2MB)',
        'delete_logo' => '로고 삭제',
        'logo_size' => '로고 크기:',
        'logo_size_small' => '작음 (60dp)',
        'logo_size_medium' => '중간 (150dp)',
        'logo_size_large' => '큼 (240dp)',
        'logo_size_help' => '최적의 외관을 위해 로고 크기 조정',
        'title' => '제목',
        'title_placeholder' => '나의 멋진 앱',
        'subtitle' => '부제목',
        'subtitle_placeholder' => '최고의 앱에 오신 것을 환영합니다',
        'text_theme' => '텍스트 테마',
        'text_theme_light' => '라이트 (흰색 텍스트)',
        'text_theme_dark' => '다크 (검은색 텍스트)',
    ],

    // Drawer Settings
    'drawer' => [
        'appearance' => '드로어 외관',
        'appearance_description' => '내비게이션 드로어의 배경 및 시각적 스타일 커스터마이징',
        'drawer_mode' => '드로어 모드',
        'drawer_mode_help' => '드로어 배경이 표시되는 방식 선택',
        'mode_default' => '기본 (테마 색상)',
        'mode_color' => '커스텀 색상',
        'mode_image' => '배경 이미지',
        'background_color' => '배경색',
        'background_color_help' => '드로어의 커스텀 배경색',
        'background_image' => '배경 이미지',
        'background_image_help' => 'PNG만 가능 (최대 2MB). 권장: 1080x1920px',
        'delete_background_image' => '배경 이미지 삭제',
        'branding' => '드로어 브랜딩',
        'branding_description' => '드로어 헤더에 로고, 제목 추가 및 텍스트 외관 커스터마이징',
        'show_logo' => '드로어에 로고 표시',
        'show_logo_help' => '드로어 헤더에 로고 표시',
        'logo_light' => '드로어 로고 (라이트 모드)',
        'logo_light_help' => '투명 배경 PNG 필수 (최대 2MB) - 앱이 라이트 테마일 때 표시',
        'delete_light_logo' => '라이트 로고 삭제',
        'logo_dark' => '드로어 로고 (다크 모드)',
        'logo_dark_help' => '투명 배경 PNG 필수 (최대 2MB) - 앱이 다크 테마일 때 표시',
        'delete_dark_logo' => '다크 로고 삭제',
        'logo_size' => '로고 크기:',
        'logo_size_small' => '작음 (40dp)',
        'logo_size_medium' => '중간 (120dp)',
        'logo_size_large' => '큼 (200dp)',
        'logo_size_help' => '최적의 외관을 위해 로고 크기 조정',
        'drawer_title' => '드로어 제목',
        'drawer_title_placeholder' => '나의 앱',
        'drawer_title_help' => '드로어 헤더에 표시되는 제목',
        'drawer_subtitle' => '드로어 부제목',
        'drawer_subtitle_placeholder' => '나의 앱에 오신 것을 환영합니다',
        'drawer_subtitle_help' => '제목 아래에 표시되는 부제목 또는 태그라인',
        'text_theme' => '텍스트 테마',
        'text_theme_help' => '드로어 헤더 및 메뉴 항목의 텍스트 색상',
        'text_theme_light' => '라이트 (흰색 텍스트)',
        'text_theme_dark' => '다크 (검은색 텍스트)',
        'item_colors' => '드로어 항목 색상',
        'item_colors_description' => '드로어 메뉴 항목의 아이콘 및 텍스트 색상 커스터마이징',
        'item_icon_colors' => '드로어 항목 아이콘 색상',
        'item_icon_colors_help' => '라이트 및 다크 모드에서 비활성 드로어 항목 아이콘 및 텍스트 색상',
        'active_item_colors' => '활성 항목 색상',
        'active_item_colors_help' => '라이트 및 다크 모드에서 선택된/활성 드로어 항목의 색상',
        'light_mode' => '라이트 모드',
        'dark_mode' => '다크 모드',
    ],

    // Navigation Settings
    'navigation' => [
        'bottom_nav_bar' => '하단 내비게이션 바',
        'bottom_nav_bar_description' => '하단 내비게이션 탭 항목 구성 (최대 8개)',
        'add_item' => '+ 항목 추가',
        'no_navigation_items' => '내비게이션 항목이 설정되지 않았습니다',
        'add_first_navigation_item' => '첫 번째 내비게이션 항목을 추가하세요',
        'home_tab_badge' => '홈 탭 - 메인 URL과 동기화됨',
        'home_item_badge' => '홈 항목 - 메인 URL과 동기화됨',
        'label' => '라벨',
        'label_placeholder_home' => '홈',
        'label_placeholder_about' => '소개',
        'action_type' => '액션 유형',
        'action_internal' => '내부 링크',
        'action_external' => '외부 링크',
        'action_hosted_page' => '호스팅 페이지',
        'action_share' => '공유',
        'action_email' => '이메일 보내기',
        'action_call' => '전화 걸기',
        'url' => 'URL',
        'email_address' => '이메일 주소',
        'phone_number' => '전화번호',
        'hosted_page' => '호스팅 페이지',
        'select_page' => '페이지 선택',
        'synced_from_general' => '일반 설정에서 자동으로 동기화됨',
        'icon' => '아이콘',
        'select_icon' => '아이콘 선택',
        'search_icons' => '아이콘 검색...',
        'home_tab_cannot_delete' => '홈 탭은 삭제할 수 없습니다',
        'home_item_cannot_delete' => '홈 항목은 삭제할 수 없습니다',
        'max_navigation_items' => '최대 8개의 내비게이션 항목에 도달했습니다 (홈 탭 제외)',
        'app_bar_buttons' => '앱 바 버튼',
        'app_bar_buttons_description' => '앱 바 오른쪽 상단에 액션 버튼 추가 (최대 3개)',
        'add_button' => '+ 버튼 추가',
        'no_app_bar_buttons' => '앱 바 버튼이 설정되지 않았습니다',
        'add_first_app_bar_button' => '첫 번째 앱 바 버튼을 추가하세요',
        'max_app_bar_buttons' => '최대 3개의 앱 바 버튼에 도달했습니다',
        'drawer_menu_items' => '드로어 메뉴 항목',
        'drawer_menu_items_description' => '내비게이션 드로어 메뉴 항목 구성 (홈 1개 + 추가 최대 9개)',
        'no_drawer_items' => '드로어 메뉴 항목이 설정되지 않았습니다',
        'add_first_drawer_item' => '첫 번째 드로어 메뉴 항목을 추가하세요',
        'max_drawer_items' => '최대 9개의 추가 항목에 도달했습니다 (홈 항목 포함 총 10개)',
        'behavior_settings' => '동작 설정',
        'behavior_settings_description' => '사용자 상호작용 구성',
        'pull_to_refresh' => '당겨서 새로고침',
        'pull_to_refresh_description' => '사용자가 아래로 당겨 콘텐츠를 새로고침할 수 있도록 허용',
        'swipe_navigation' => '스와이프 내비게이션',
        'swipe_navigation_description' => '사용자가 가장자리에서 스와이프하여 뒤로 이동할 수 있도록 허용',
        'swipe_navigation_disabled' => '드로어 레이아웃에서 제스처 충돌을 방지하기 위해 비활성화됨',
        'preserve_tab_state' => '탭 상태 유지',
        'preserve_tab_state_description' => '탭/드로어 항목 간 전환 시 현재 페이지 유지',
    ],

    // Sidebar
    'sidebar' => [
        'app_settings' => '앱 설정',
        'general' => '일반',
        'design' => '디자인',
        'icon' => '아이콘',
        'splashscreen' => '스플래시 화면',
        'navigation' => '내비게이션',
        'drawer' => '드로어',
        'webview' => 'WebView',
        'permissions' => '권한',
        'custom_code' => '커스텀 코드',
        'hosted_pages' => '호스팅 페이지',
        'notifications' => '알림',
        'deployment' => '배포',
        'builds' => '빌드',
        'signing' => '서명',
        'back_to_apps' => '앱으로 돌아가기',
    ],

    // WebView Settings
    'webview_user_agent_title' => '사용자 에이전트',
    'webview_user_agent_description' => '브라우저 사용자 에이전트 문자열 커스터마이징',
    'webview_custom_user_agent' => '커스텀 사용자 에이전트',
    'webview_user_agent_placeholder' => '기본 Android WebView 사용자 에이전트를 사용하려면 비워두세요',
    'webview_user_agent_helper' => '선택사항. 웹사이트에 전송되는 기본 사용자 에이전트를 재정의합니다.',
    'webview_features_title' => 'WebView 기능',
    'webview_features_description' => '브라우저 기능 및 동작 구성',
    'webview_enable_javascript' => 'JavaScript 활성화',
    'webview_enable_javascript_description' => 'WebView에서 JavaScript 실행 허용',
    'webview_enable_dom_storage' => 'DOM 스토리지 활성화',
    'webview_enable_dom_storage_description' => 'localStorage 및 sessionStorage API 허용',
    'webview_enable_zoom_controls' => '줌 컨트롤 활성화',
    'webview_enable_zoom_controls_description' => '핀치-투-줌 및 줌 컨트롤 허용',
    'webview_enable_cache' => '캐시 활성화',
    'webview_enable_cache_description' => '더 빠른 로딩을 위해 웹 콘텐츠 캐시',

    // Permissions Settings
    'permissions_location_title' => '위치 권한',
    'permissions_location_description' => '위치 기반 기능을 위해 기기 GPS에 액세스',
    'permissions_enable_location' => '위치 액세스 활성화',
    'permissions_location_helper' => '지도, 위치 기반 콘텐츠, 지오펜싱 기능에 필요합니다.',
    'permissions_show_code_example' => '코드 예제 보기',
    'permissions_hide_code_example' => '코드 예제 숨기기',
    'permissions_javascript_example' => 'JavaScript 예제:',
    'permissions_camera_title' => '카메라 권한',
    'permissions_camera_description' => '사진 및 동영상을 위해 기기 카메라에 액세스',
    'permissions_enable_camera' => '카메라 액세스 활성화',
    'permissions_camera_helper' => '사진 촬영, QR 코드 스캔, 영상 통화에 필요합니다.',
    'permissions_storage_title' => '저장소 권한',
    'permissions_storage_description' => '파일 업로드 및 다운로드를 위해 기기 저장소에 액세스',
    'permissions_enable_storage' => '저장소 액세스 활성화',
    'permissions_storage_helper' => '파일 업로드, 이미지 선택, 파일 다운로드에 필요합니다.',
    'permissions_microphone_title' => '마이크 권한',
    'permissions_microphone_description' => '오디오 녹음을 위해 기기 마이크에 액세스',
    'permissions_enable_microphone' => '마이크 액세스 활성화',
    'permissions_microphone_helper' => '음성 녹음, 음성 통화, 음성 인식에 필요합니다.',
    'permissions_contacts_title' => '연락처 권한',
    'permissions_contacts_description' => '소셜 기능을 위해 기기 연락처에 액세스',
    'permissions_enable_contacts' => '연락처 액세스 활성화',
    'permissions_contacts_helper' => '연락처 선택, 초대 기능, 소셜 통합에 필요합니다.',
    'permissions_vibrate_title' => '진동 권한',
    'permissions_vibrate_description' => '햅틱 피드백을 위해 기기 진동 모터에 액세스',
    'permissions_enable_vibrate' => '진동 활성화',
    'permissions_vibrate_helper' => '햅틱 피드백 및 알림 진동에 필요합니다.',

    // Custom Code Settings
    'custom_code_access_required_title' => '업그레이드 필요',
    'custom_code_access_required_description' => '현재 플랜에는 커스텀 코드 주입이 포함되어 있지 않습니다. 이 기능에 액세스하여 앱에 커스텀 CSS 및 JavaScript를 추가하려면 업그레이드하세요.',
    'custom_code_upgrade_plan' => '플랜 업그레이드',
    'custom_code_enable_feature' => '이 기능을 활성화합니다.',
    'custom_code_css_title' => '커스텀 CSS',
    'custom_code_css_description' => '앱 외관을 개인화하기 위한 커스텀 스타일 추가',
    'custom_code_css_label' => 'CSS 코드',
    'custom_code_css_helper' => '최대 100KB. CSS는 모든 페이지에 주입됩니다.',
    'custom_code_js_title' => '커스텀 JavaScript',
    'custom_code_js_description' => '확장된 기능을 위한 커스텀 스크립트 추가',
    'custom_code_js_label' => 'JavaScript 코드',
    'custom_code_js_helper' => '최대 100KB. JavaScript는 WebView에서 실행됩니다.',

    // Notifications Settings
    'notifications_title' => '알림',
    'notifications_description' => '알림을 위한 Firebase Cloud Messaging (FCM) 구성',
    'notifications_enable' => '알림 활성화',
    'notifications_firebase_service_account' => 'Firebase 서비스 계정',
    'notifications_firebase_service_account_description' => 'FCM API를 통해 알림을 보내는 데 서버에서 사용됩니다',
    'notifications_firebase_help_text' => 'JSON 파일 (최대 2MB)',
    'notifications_delete_firebase_credentials' => 'Firebase 자격 증명 삭제',
    'notifications_delete_firebase_credentials_confirm' => 'Firebase 자격 증명 파일을 삭제하시겠습니까?',
    'notifications_google_services' => 'Google Services',
    'notifications_google_services_description' => 'Android 앱 구성에 필요',
    'notifications_google_services_help_text' => 'JSON 파일 (최대 1MB)',
    'notifications_delete_google_services' => 'Google Services 파일 삭제',
    'notifications_delete_google_services_confirm' => 'Google Services 파일을 삭제하시겠습니까?',

    // Signing Keys Settings
    'signing_keys' => [
        'android_keystores' => 'Android 키스토어',
        'generate_new' => '새로 생성',
        'upload_existing' => '기존 업로드',
        'default_badge' => '기본',
        'alias' => '별칭',
        'alias_placeholder' => 'my-key-alias',
        'auto_generated' => '자동 생성됨',
        'created' => '생성됨',
        'set_as_default' => '기본값으로 설정',
        'edit' => '편집',
        'delete' => '삭제',
        'no_keystores' => 'Android 키스토어가 없습니다. 새 키를 생성하거나 기존 키를 업로드하세요.',
        'upload_signing_key' => '서명 키 업로드',
        'android_keystore_upload' => 'Android 키스토어 업로드',
        'keystore_name' => '키스토어 이름',
        'keystore_name_placeholder' => '나의 릴리스 키스토어',
        'keystore_file' => '키스토어 파일',
        'keystore_file_help' => '.jks, .keystore 또는 .ks 파일 (최대 5MB)',
        'upload_custom_key' => '커스텀 키 업로드',
        'upload_custom_key_help' => '자동 생성된 디버그 키스토어를 사용하는 경우 체크 해제',
        'password' => '비밀번호',
        'password_placeholder' => '••••••••',
        'password_help' => '키스토어 및 키 액세스에 모두 사용됩니다',
        'cancel' => '취소',
        'upload' => '업로드',
        'edit_keystore' => '키스토어 편집',
        'update_password' => '비밀번호 업데이트',
        'save' => '저장',
        'delete_keystore' => '키스토어 삭제',
        'delete_confirmation' => '정말 삭제하시겠습니까',
        'action_cannot_be_undone' => '이 작업은 되돌릴 수 없습니다.',

        // Keystore Generator Modal
        'generate_signing_key' => '서명 키 생성',
        'generate_android_keystore' => 'Android 키스토어 생성',
        'generate_keystore_description' => '새 JKS 키스토어가 빌드 서버에서 안전하게 생성됩니다',
        'keystore_name_generate_placeholder' => '나의 앱 릴리스 키',
        'key_alias' => '키 별칭',
        'key_alias_placeholder' => 'my-app-key',
        'key_alias_help' => '문자로 시작해야 합니다. 문자, 숫자, 하이픈, 밑줄만 허용됩니다.',
        'password_settings' => '비밀번호 설정',
        'keystore_password' => '키스토어 비밀번호',
        'min_characters_placeholder' => '최소 6자',
        'use_same_password' => '키와 키스토어에 동일한 비밀번호 사용',
        'key_password' => '키 비밀번호',
        'validity_period' => '유효 기간',
        'years_10' => '10년',
        'years_15' => '15년',
        'years_20' => '20년',
        'years_25_recommended' => '25년 (권장)',
        'years_30' => '30년',
        'validity_help' => 'Google Play는 새 앱에 최소 25년 유효 기간을 요구합니다',
        'certificate_details' => '인증서 세부 정보 (선택사항)',
        'common_name' => '일반 이름 (CN)',
        'common_name_placeholder' => '앱 또는 조직 이름',
        'organization' => '조직 (O)',
        'organization_placeholder' => '회사 이름',
        'organizational_unit' => '조직 단위 (OU)',
        'organizational_unit_placeholder' => '모바일 앱',
        'city' => '도시 (L)',
        'city_placeholder' => '서울',
        'state' => '주/도 (ST)',
        'state_placeholder' => '서울',
        'country' => '국가 (C)',
        'country_placeholder' => 'KR',
        'save_password_warning' => '중요: 비밀번호를 안전하게 저장하세요!',
        'save_password_description' => '키스토어가 암호화되어 저장됩니다. 향후 빌드에 비밀번호가 필요합니다. 분실된 비밀번호는 복구할 수 없습니다.',
        'generating' => '생성 중...',
        'generate_keystore' => '키스토어 생성',
    ],

    // Hosted Pages Settings
    'hosted_pages' => [
        'access_required' => '호스팅 페이지 액세스 필요',
        'upgrade_description' => '현재 플랜에는 호스팅 페이지가 포함되어 있지 않습니다. 저희가 호스팅하는 커스텀 페이지를 만들려면 플랜을 업그레이드하세요.',
        'upgrade_plan' => '플랜 업그레이드',
        'upgrade_suffix' => '이 기능을 활성화합니다.',
        'table_page' => '페이지',
        'table_status' => '상태',
        'table_created' => '생성됨',
        'table_actions' => '작업',
        'status_published' => '게시됨',
        'status_draft' => '임시저장',
        'edit' => '편집',
        'delete' => '삭제',
        'no_pages' => '아직 페이지가 없습니다',
        'no_pages_description' => '"페이지 추가"를 클릭하여 첫 번째 호스팅 페이지를 만드세요.',
    ],

    // Hosted Page Editor Modal
    'hosted_page_editor' => [
        'create_page' => '페이지 생성',
        'edit_page' => '페이지 편집',
        'title' => '제목',
        'title_placeholder' => '페이지 제목',
        'slug' => '슬러그',
        'slug_placeholder' => 'page-slug',
        'start_from_template' => '템플릿으로 시작',
        'status' => '상태',
        'status_help' => '게시된 페이지만 앱에서 액세스할 수 있습니다',
        'cancel' => '취소',
        'save_changes' => '변경사항 저장',
    ],

    // WordPress-specific Settings
    'wordpress' => [
        // General Settings
        'app_name_placeholder' => '나의 WordPress 앱',
        'wordpress_site_url' => 'WordPress 사이트 URL',
        'wordpress_site_url_placeholder' => 'https://myblog.wordpress.com',
        'wordpress_site_url_help' => 'WordPress.com 사이트 URL을 입력하세요 (예: myblog.wordpress.com)',
        'app_id_placeholder' => 'com.example.wordpress',
        'package_name_help' => '역방향 도메인 형식의 고유 식별자 (예: com.company.wordpress). 생성 후 변경할 수 없습니다.',

        // Design Settings
        'post_list_style' => '포스트 목록 스타일',
        'style_list' => '목록',
        'style_grid' => '그리드',
        'style_magazine' => '매거진',
        'post_list_style_help' => '앱에서 포스트가 표시되는 방식',
        'progress_indicator_help' => '포스트를 가져올 때 표시되는 로딩 인디케이터 스타일',
        'show_app_bar_title' => '앱 바에 앱 이름 표시',
        'show_app_bar_title_help' => '상단 바에 앱 이름을 표시합니다',
        'nav_tab_icon_colors_help' => '비활성 탭 아이콘의 색상',
        'active_tab_colors_help' => '선택된 탭의 색상',
        'theme_color_help' => '앱 전체에서 사용되는 메인 색상 (WordPress 블루: #21759B)',
        'dynamic_colors_help' => '활성화하면 Android 12+ 기기에서 사용자의 배경화면에서 색상을 적용합니다.',
        'layout_list_only' => '목록만',

        // Splashscreen Settings
        'splashscreen_title_placeholder' => '나의 WordPress 앱',
        'splashscreen_subtitle_placeholder' => '최고의 블로그 앱에 오신 것을 환영합니다',

        // Sidebar
        'content' => '콘텐츠',
        'features' => '기능',

        // Drawer Settings
        'drawer_appearance_description' => '내비게이션 드로어 배경 커스터마이징',
        'drawer_branding_description' => '로고, 제목, 텍스트 스타일링',
        'logo_light_mode' => '로고 (라이트 모드)',
        'logo_dark_mode' => '로고 (다크 모드)',
        'png_transparency_help' => '투명 배경 PNG (최대 2MB)',
        'delete_background' => '배경 삭제',
        'drawer_title_placeholder' => '나의 WordPress 앱',
        'drawer_subtitle_placeholder' => '여기에 태그라인 입력',
        'item_colors_description' => '메뉴 항목의 아이콘 및 텍스트 색상',
        'inactive_item_colors' => '비활성 항목 색상',

        // Navigation Settings
        'bottom_nav_tabs' => '하단 내비게이션 탭',
        'bottom_nav_tabs_description' => '하단 내비게이션 항목 구성 (최대 8개 + 홈)',
        'add_tab' => '+ 탭 추가',
        'home_tab_shows_all_posts' => '홈 탭 - 모든 포스트 표시',
        'home_item_shows_all_posts' => '홈 항목 - 모든 포스트 표시',
        'tab_name_placeholder' => '탭 이름',
        'menu_item_placeholder' => '메뉴 항목',
        'action_category' => '카테고리',
        'action_tag' => '태그',
        'action_search' => '검색',
        'action_bookmarks' => '북마크',
        'action_share' => '공유',
        'category_slug' => '카테고리 슬러그',
        'tag_slug' => '태그 슬러그',
        'category_slug_placeholder' => 'technology',
        'tag_slug_placeholder' => 'featured',
        'app_bar_buttons_description' => '오른쪽 상단의 액션 버튼 (최대 3개)',
        'no_app_bar_buttons_description' => '앱 바 버튼이 설정되지 않았습니다. 검색, 공유 등의 빠른 액션을 추가하세요.',
        'search_placeholder' => '검색',
        'drawer_menu_items_description' => '내비게이션 드로어 메뉴 항목 (홈 1개 + 최대 9개)',
        'swipe_navigation_description' => '가장자리에서 스와이프하여 뒤로 이동',
        'preserve_tab_state_description' => '탭 전환 시 스크롤 위치 유지',

        // Content Settings
        'post_display' => '포스트 표시',
        'post_display_description' => '앱에서 포스트가 표시되는 방식 구성',
        'posts_per_page' => '페이지당 포스트 수',
        'posts_per_page_help' => '한 번에 로드되는 포스트 수 (1-50)',
        'excerpt_length' => '발췌 길이 (자)',
        'excerpt_length_help' => '포스트 발췌에 표시되는 최대 문자 수 (50-500)',
        'post_metadata' => '포스트 메타데이터',
        'post_metadata_description' => '각 포스트와 함께 표시할 정보 선택',
        'show_featured_image' => '대표 이미지 표시',
        'show_featured_image_help' => '포스트의 대표/썸네일 이미지 표시',
        'show_excerpt' => '포스트 발췌 표시',
        'show_excerpt_help' => '포스트 내용 미리보기 표시',
        'show_author' => '작성자 이름 표시',
        'show_author_help' => '포스트를 작성한 저자 표시',
        'show_date' => '게시일 표시',
        'show_date_help' => '포스트가 게시된 날짜 표시',
        'show_categories' => '카테고리 표시',
        'show_categories_help' => '포스트에 할당된 카테고리 표시',
        'show_reading_time' => '예상 읽기 시간 표시',
        'show_reading_time_help' => '포스트를 읽는 데 걸리는 시간 표시',

        // Features Settings
        'core_features' => '핵심 기능',
        'core_features_description' => '앱 기능 활성화 또는 비활성화',
        'enable_search' => '검색 활성화',
        'enable_search_help' => '사용자가 앱에서 포스트를 검색할 수 있도록 허용',
        'enable_comments' => '댓글 활성화',
        'enable_comments_help' => '사용자가 기사에서 댓글을 보고 작성할 수 있도록 허용',
        'enable_bookmarks' => '북마크 활성화',
        'enable_bookmarks_help' => '사용자가 나중에 읽기 위해 포스트를 저장할 수 있도록 허용',
        'enable_share' => '공유 활성화',
        'enable_share_help' => '사용자가 다른 앱을 통해 포스트를 공유할 수 있도록 허용',
        'advanced_features' => '고급 기능',
        'advanced_features_description' => '향상된 사용자 경험을 위한 추가 기능',
        'enable_offline_reading' => '오프라인 읽기 활성화',
        'enable_offline_reading_help' => '인터넷 연결 없이 읽을 수 있도록 포스트 캐시',
        'enable_user_auth' => '사용자 인증 활성화',
        'enable_user_auth_help' => '사용자가 WordPress.com 계정으로 로그인할 수 있도록 허용',
        'enable_push_notifications' => '푸시 알림 활성화',
        'enable_push_notifications_help' => '새 포스트가 게시되면 알림 전송',
    ],

    // Builds
    'builds' => [
        // Builds Table
        'search_placeholder' => '빌드 검색...',
        'filter' => '필터',
        'platform_filter' => '플랫폼',
        'status_filter' => '상태',
        'android' => 'Android',
        'completed' => '완료',
        'building' => '빌드 중',
        'failed' => '실패',
        'pending' => '대기 중',
        'table_platform' => '플랫폼',
        'table_build_info' => '빌드 정보',
        'table_created' => '생성됨',
        'table_actions' => '작업',
        'release' => '릴리스',
        'debug' => '디버그',
        'download' => '다운로드',
        'preview' => '미리보기',
        'logs' => '로그',
        'delete' => '삭제',
        'no_builds' => '빌드를 찾을 수 없습니다',

        // Build Modal
        'create_new_build' => '새 빌드 생성',
        'platform_label' => '플랫폼',
        'build_costs_credit' => '빌드에 :count 크레딧이 필요합니다|빌드에 :count 크레딧이 필요합니다',
        'build_type_label' => '빌드 유형',
        'for_testing' => '테스트용',
        'for_production' => '프로덕션용',
        'output_format_label' => '출력 형식',
        'apk' => 'APK',
        'aab' => 'AAB',
        'for_testing_sideloading' => '테스트/사이드로딩용',
        'for_google_play_store' => 'Google Play Store용',
        'builder_label' => '빌더',
        'auto_select_recommended' => '자동 선택 (권장)',
        'auto_select_help' => '가장 한가한 빌더를 사용하려면 "자동 선택"으로 두거나 특정 빌더를 선택하세요.',
        'no_builders_available' => '사용 가능한 빌더가 없습니다!',
        'no_builders_help' => '현재 플랜에서 사용 가능한 빌더가 없습니다. 고객 지원에 문의하거나 플랜을 업그레이드하세요.',
        'signing_key_label' => '서명 키',
        'select_keystore' => '키스토어 선택',
        'no_keystores_available' => '사용 가능한 키스토어가 없습니다.',
        'upload_in_signing_section' => '서명 섹션에서 업로드하세요',
        'signing_key_required' => '서명 키가 필요합니다!',
        'version_name_label' => '버전 이름',
        'version_name_help' => '형식: X.Y 또는 X.Y.Z (예: 1.0 또는 1.0.0). 각 플랫폼별로 자동 증가됩니다.',
        'build_number_label' => '빌드 번호',
        'next_build_number' => '다음 빌드 번호',
        'build_number_auto_increment' => '빌드 번호는 각 빌드마다 자동으로 증가합니다',
        'build_cost_info' => '이 빌드에 :count 크레딧이 필요합니다|이 빌드에 :count 크레딧이 필요합니다',
        'build_email_notification' => '빌드가 다운로드 준비되면 이메일로 알려드리겠습니다.',
        'cancel' => '취소',
        'start_build' => '빌드 시작',
        'credit' => '크레딧',
        'credits' => '크레딧',
        'builder_info' => '빌더:',

        // Build Logs Modal
        'build_logs' => '빌드 로그',
        'duration' => '시간:',
        'no_logs_available' => '이 빌드에 대한 로그가 없습니다',
        'error' => '오류:',
        'close' => '닫기',
        'download_build' => '빌드 다운로드',

        // Build Download Modal
        'download_build_title' => '빌드 다운로드',
        'aab_title' => 'Android App Bundle (AAB)',
        'aab_description' => '이것은 기기에 직접 설치할 수 없는 AAB 파일입니다. AAB 파일은 Google Play Console에 업로드하도록 설계되었으며, Google이 사용자를 위해 최적화된 APK를 생성합니다.',
        'scan_with_android' => 'Android 기기로 스캔',
        'qr_unavailable' => 'QR 코드를 사용할 수 없습니다',
        'download_options' => '다운로드 옵션',
        'download_options_description' => '모바일 기기로 QR 코드를 스캔하거나 아래 직접 다운로드 링크를 사용하세요.',
        'download_format' => ':format 다운로드',
        'installation_note' => '설치:',
        'installation_help' => 'Android 설정에서 "알 수 없는 소스에서 설치"를 활성화해야 할 수 있습니다.',
        'download_aab_file' => 'AAB 파일 다운로드',
        'upload_to_play_console' => '이 파일을 Google Play Console에 업로드하여 앱을 게시하세요.',
        'next_steps' => '다음 단계:',
        'next_steps_help' => '이 AAB 파일을 Google Play Console의 출시 > 프로덕션/테스트에 업로드하세요. Google이 자동으로 사용자를 위해 최적화된 APK를 생성합니다.',

        // Delete Build Modal
        'delete_build' => '빌드 삭제',
        'delete_confirmation' => '정말 삭제하시겠습니까',
        'build_suffix' => '빌드를?',
        'action_cannot_be_undone' => '이 작업은 되돌릴 수 없습니다.',
    ],

    // App Preview Panel
    'preview' => [
        'no_build_selected' => '선택된 빌드 없음',
        'select_build_help' => '빌드 탭에서 완료된 빌드를 선택하여 여기서 미리보기하세요',
    ],

    // App Creation Form
    'creation' => [
        'website_url' => '웹사이트 URL',
        'app_id' => 'APP ID',
        'app_id_tooltip' => '고유 패키지 식별자 (생성 후 변경 불가)',
        'auto_generate_package' => '앱 이름에서 자동 생성',
        'package_name_help' => '역방향 도메인 형식의 고유 식별자 (예: com.company.app). 생성 후 변경할 수 없습니다.',
        'theme_color' => '테마 색상',
        'theme_color_help' => '앱 전체에서 사용되는 메인 색상. 텍스트 색상은 기본 검정/흰색을 사용하며 나중에 커스터마이징할 수 있습니다.',
        'layout_template' => '레이아웃 템플릿',
        'layout_app_bar_drawer' => '앱 바 + 드로어',
        'layout_app_bar_tabs' => '앱 바 + 내비게이션 탭',
        'layout_app_bar' => '앱 바',
        'layout_blank' => '블랭크',
        'layout_help' => '앱의 내비게이션 구조 선택',
    ],

    // Delete Modals
    'modals' => [
        'cancel' => '취소',
        'delete' => '삭제',
        'action_cannot_be_undone' => '이 작업은 되돌릴 수 없습니다.',
        'delete_build' => '빌드 삭제',
        'delete_build_confirmation' => '정말 삭제하시겠습니까',
        'build_suffix' => '빌드를?',
        'delete_app_icon' => '앱 아이콘 삭제',
        'delete_icon_confirmation' => '정말 아이콘을 삭제하시겠습니까',
        'delete_keystore' => '키스토어 삭제',
        'delete_keystore_confirmation' => '정말 삭제하시겠습니까',
        'delete_splashscreen_background' => '스플래시 화면 배경 삭제',
        'delete_splashscreen_background_confirmation' => '정말 스플래시 화면 배경 이미지를 삭제하시겠습니까',
        'delete_splashscreen_logo' => '스플래시 화면 로고 삭제',
        'delete_splashscreen_logo_confirmation' => '정말 스플래시 화면 로고를 삭제하시겠습니까',
        'delete_drawer_background' => '드로어 배경 삭제',
        'delete_drawer_background_confirmation' => '정말 드로어 배경 이미지를 삭제하시겠습니까',
        'delete_dark_mode_logo' => '다크 모드 로고 삭제',
        'delete_dark_mode_logo_confirmation' => '정말 드로어 다크 모드 로고를 삭제하시겠습니까',
        'delete_light_mode_logo' => '라이트 모드 로고 삭제',
        'delete_light_mode_logo_confirmation' => '정말 드로어 라이트 모드 로고를 삭제하시겠습니까',
        'delete_page' => '페이지 삭제',
        'delete_page_confirmation' => '정말 삭제하시겠습니까',
        'delete_page_warning' => '이 작업은 되돌릴 수 없습니다. 이 페이지가 내비게이션에 사용 중인 경우 더 이상 액세스할 수 없습니다.',
    ],

    // WordPress Notifications Settings
    'notifications_wp' => [
        'title' => '푸시 알림',
        'description' => '푸시 알림을 위한 Firebase Cloud Messaging 구성',
        'enable_label' => '푸시 알림 활성화',
        'enable_help' => '새 포스트가 게시되면 알림 전송',
        'firebase_required_title' => 'Firebase 설정 필요',
        'firebase_required_description' => '앱에서 푸시 알림을 활성화하려면 아래 두 설정 파일을 업로드하세요.',
        'google_services_label' => 'google-services.json',
        'file_uploaded' => '파일 업로드됨',
        'google_services_configured' => 'google-services.json이 설정되었습니다',
        'delete' => '삭제',
        'delete_file_confirm' => '이 파일을 삭제하시겠습니까?',
        'upload_google_services' => 'google-services.json 업로드',
        'google_services_help' => 'Firebase Console에서 다운로드 (최대 1MB)',
        'google_services_instructions' => 'Firebase Console > Project Settings > Your apps > Android app에서 다운로드',
        'firebase_service_account_label' => 'Firebase 서비스 계정 (알림 전송용)',
        'credentials_configured' => '자격 증명 설정됨',
        'service_account_stored' => '서비스 계정이 안전하게 저장되었습니다',
        'delete_credentials_confirm' => '이 자격 증명을 삭제하시겠습니까?',
        'upload_service_account' => '서비스 계정 JSON 업로드',
        'service_account_help' => 'Firebase Console에서 다운로드 (최대 2MB)',
        'service_account_instructions' => 'Firebase Console > Project Settings > Service Accounts > Generate new private key에서 다운로드',
        'setup_title' => 'Firebase 설정 방법:',
        'setup_step_1' => '이동',
        'setup_step_2' => '프로젝트를 생성하거나 기존 프로젝트 선택',
        'setup_step_3' => '패키지 이름으로 Android 앱 추가:',
        'setup_step_4' => '다운로드',
        'setup_step_4_suffix' => '그리고 위에 업로드',
        'setup_step_5' => 'Project Settings > Service Accounts로 이동',
        'setup_step_6' => '새 비공개 키를 생성하고 위에 업로드',
    ],

    // Toast Messages - Settings
    'toast' => [
        // General success/error
        'settings_saved' => ':section 설정이 저장되었습니다!',
        'settings_save_failed' => '설정 저장에 실패했습니다. 다시 시도해 주세요.',

        // Design settings
        'design_saved' => '디자인 설정이 저장되었습니다!',

        // Navigation settings
        'navigation_saved' => '내비게이션 설정이 저장되었습니다!',
        'home_tab_cannot_delete' => '홈 탭은 삭제할 수 없습니다. 내비게이션에 필요합니다.',
        'home_tab_cannot_move' => '홈 탭은 첫 번째 위치에 있어야 하며 이동할 수 없습니다.',
        'cannot_move_below_home' => '항목을 홈 탭 아래로 이동할 수 없습니다.',
        'home_item_cannot_delete' => '홈 항목은 삭제할 수 없습니다. 내비게이션에 필요합니다.',
        'home_item_cannot_move' => '홈 항목은 첫 번째 위치에 있어야 하며 이동할 수 없습니다.',
        'cannot_move_below_home_item' => '항목을 홈 항목 아래로 이동할 수 없습니다.',

        // Custom code
        'custom_code_saved' => '커스텀 코드가 저장되었습니다!',
        'custom_code_save_failed' => '커스텀 코드 저장에 실패했습니다. 다시 시도해 주세요.',
        'custom_code_no_access' => '현재 플랜에는 커스텀 코드 액세스가 포함되어 있지 않습니다. 플랜을 업그레이드해 주세요.',

        // WebView settings
        'webview_saved' => 'WebView 설정이 저장되었습니다!',

        // Permissions settings
        'permissions_saved' => '권한이 저장되었습니다!',

        // Drawer settings
        'drawer_saved' => '드로어 설정이 저장되었습니다!',

        // General settings
        'general_saved' => '일반 설정이 저장되었습니다!',

        // Splashscreen settings
        'splashscreen_saved' => '스플래시 화면 설정이 저장되었습니다!',

        // Icon settings
        'icon_uploaded' => '앱 아이콘이 업로드되었습니다!',
        'icon_upload_failed' => '아이콘 업로드 실패: :error',
        'icon_removed' => '앱 아이콘이 제거되었습니다!',
        'icon_remove_failed' => '아이콘 제거에 실패했습니다. 다시 시도해 주세요.',

        // Splashscreen modals
        'splashscreen_background_deleted' => '스플래시 화면 배경 이미지가 삭제되었습니다!',
        'splashscreen_background_delete_failed' => '배경 이미지 삭제에 실패했습니다. 다시 시도해 주세요.',
        'splashscreen_logo_deleted' => '스플래시 화면 로고가 삭제되었습니다!',
        'splashscreen_logo_delete_failed' => '로고 삭제에 실패했습니다. 다시 시도해 주세요.',

        // Drawer modals
        'drawer_background_deleted' => '드로어 배경 이미지가 삭제되었습니다!',
        'drawer_background_delete_failed' => '배경 이미지 삭제에 실패했습니다. 다시 시도해 주세요.',
        'drawer_logo_deleted' => '드로어 로고가 삭제되었습니다!',
        'drawer_logo_delete_failed' => '로고 삭제에 실패했습니다. 다시 시도해 주세요.',
        'drawer_logo_light_deleted' => '드로어 라이트 모드 로고가 삭제되었습니다!',
        'drawer_logo_dark_deleted' => '드로어 다크 모드 로고가 삭제되었습니다!',

        // Notifications settings
        'notifications_saved' => '알림 설정이 저장되었습니다!',
        'firebase_credentials_deleted' => 'Firebase 자격 증명이 삭제되었습니다!',
        'firebase_credentials_delete_failed' => 'Firebase 자격 증명 삭제에 실패했습니다. 다시 시도해 주세요.',
        'google_services_deleted' => 'Google Services 파일이 삭제되었습니다!',
        'google_services_delete_failed' => 'Google Services 파일 삭제에 실패했습니다. 다시 시도해 주세요.',

        // Signing keys
        'keystore_updated' => '키스토어가 업데이트되었습니다!',
        'keystore_update_failed' => '키스토어 업데이트에 실패했습니다.',
        'keystore_load_failed' => '키스토어 로드에 실패했습니다.',
        'keystore_deleted' => '키스토어가 삭제되었습니다!',
        'keystore_delete_failed' => '키스토어 삭제에 실패했습니다. 다시 시도해 주세요.',
        'keystore_uploaded' => '키스토어가 업로드되었습니다!',
        'keystore_upload_failed' => '서명 키 업로드 실패: :error',
        'keystore_generated' => '키스토어가 생성되었습니다!',
        'keystore_set_default' => '기본 키스토어가 업데이트되었습니다!',

        // Build modal
        'build_no_builders_platform' => ':platform 플랫폼에 사용 가능한 빌더가 없습니다. 고객 지원에 문의하거나 플랜을 업그레이드해 주세요.',
        'build_no_subscription' => '앱을 빌드하려면 활성 구독이 필요합니다. 플랜을 구독해 주세요.',
        'build_no_builders_plan' => '현재 플랜에 사용 가능한 빌더가 없습니다. 고객 지원에 문의하거나 플랜을 업그레이드해 주세요.',
        'build_builder_not_available' => '선택한 빌더는 현재 플랜에서 사용할 수 없습니다.',
        'build_builder_unavailable' => '선택한 빌더를 현재 사용할 수 없습니다.',
        'build_builder_no_platform' => '선택한 빌더는 :platform 플랫폼을 지원하지 않습니다.',
        'build_insufficient_credits' => '빌드 크레딧이 부족합니다. 이 빌드에 :count 크레딧이 필요합니다. 플랜을 업그레이드하거나 월간 초기화를 기다려 주세요.',
        'build_keystore_required' => '릴리스 빌드에는 Android 키스토어가 필요합니다. 키스토어를 선택해 주세요.',
        'build_keystore_invalid' => '유효하지 않은 키스토어가 선택되었습니다.',
        'build_already_in_progress' => ':platform 빌드가 이미 진행 중입니다. 완료될 때까지 기다려 주세요.',
        'build_queued' => ':platform 빌드가 대기열에 추가되었습니다! 빌더가 사용 가능해지면 빌드가 처리됩니다. (남은 크레딧: :credits)',
        'build_queued_on_builder' => ':builder에서 :platform 빌드가 대기열에 추가되었습니다! (남은 크레딧: :credits)',
        'build_create_failed' => '빌드 생성 실패: :error',
        'build_deleted' => '빌드가 삭제되었습니다!',
        'build_delete_failed' => '빌드 삭제에 실패했습니다. 다시 시도해 주세요.',

        // Hosted pages
        'hosted_page_saved' => '페이지가 저장되었습니다!',
        'hosted_page_save_failed' => '페이지 저장에 실패했습니다. 다시 시도해 주세요.',
        'hosted_page_deleted' => '페이지가 삭제되었습니다!',
        'hosted_page_delete_failed' => '페이지 삭제에 실패했습니다. 다시 시도해 주세요.',
        'hosted_page_limit_reached' => '현재 플랜의 호스팅 페이지 최대 수에 도달했습니다.',
        'hosted_page_no_access' => '현재 플랜에는 호스팅 페이지가 포함되어 있지 않습니다. 커스텀 페이지를 만들려면 플랜을 업그레이드하세요.',

        // Additional toast keys for AndroidWordPress
        'features_saved' => '기능 설정이 저장되었습니다!',
        'content_saved' => '콘텐츠 설정이 저장되었습니다!',
        'storage_link_missing' => '스토리지 링크를 찾을 수 없습니다. 다음을 실행하세요: php artisan storage:link',
        'splashscreen_image_deleted' => '스플래시 화면 배경 이미지가 삭제되었습니다!',
        'splashscreen_image_delete_failed' => '배경 이미지 삭제에 실패했습니다. 다시 시도해 주세요.',
        'logo_delete_failed' => '로고 삭제에 실패했습니다. 다시 시도해 주세요.',
        'default_key_updated' => '기본 서명 키가 업데이트되었습니다!',
        'default_key_update_failed' => '기본 서명 키 업데이트에 실패했습니다.',
        'keystore_uploaded_default' => '키스토어가 업로드되고 기본값으로 설정되었습니다!',
        'signing_key_upload_failed' => '서명 키 업로드 실패: :error',
        'page_not_found' => '페이지를 찾을 수 없습니다.',
        'page_deleted' => '페이지가 삭제되었습니다!',
        'page_delete_failed' => '페이지 삭제에 실패했습니다. 다시 시도해 주세요.',
        'page_updated' => '페이지가 업데이트되었습니다!',
        'page_created' => '페이지가 생성되었습니다!',
        'page_save_failed' => '페이지 저장에 실패했습니다. 다시 시도해 주세요.',
        'page_limit_reached' => '플랜의 최대 :max 페이지에 도달했습니다.',
        'hosted_pages_not_available' => '현재 플랜에는 호스팅 페이지가 포함되어 있지 않습니다. 플랜을 업그레이드해 주세요.',
        'unauthorized' => '권한이 없습니다.',
        'home_tab_required' => '홈 탭은 삭제할 수 없습니다. 내비게이션에 필요합니다.',
        'home_tab_first' => '홈 탭은 첫 번째 위치에 있어야 합니다.',
        'home_item_required' => '홈 항목은 삭제할 수 없습니다.',
        'build_no_builders' => ':platform 플랫폼에 사용 가능한 빌더가 없습니다. 고객 지원에 문의하거나 플랜을 업그레이드해 주세요.',
        'build_no_plan_builders' => '현재 플랜에 사용 가능한 빌더가 없습니다. 고객 지원에 문의하거나 플랜을 업그레이드해 주세요.',
        'build_builder_platform_unsupported' => '선택한 빌더는 :platform 플랫폼을 지원하지 않습니다.',
        'build_insufficient_credits' => '빌드 크레딧이 부족합니다. 이 빌드에 :credits 크레딧이 필요합니다. 플랜을 업그레이드하거나 월간 초기화를 기다려 주세요.',
        'build_invalid_keystore' => '유효하지 않은 키스토어가 선택되었습니다.',
        'build_queued_no_builder' => ':platform 빌드가 대기열에 추가되었습니다! 빌더가 사용 가능해지면 빌드가 처리됩니다. (남은 크레딧: :credits)',
        'build_queued_success' => ':builder에서 :platform 빌드가 대기열에 추가되었습니다! (남은 크레딧: :credits)',
        'available_builder' => '사용 가능한 빌더',
        'invalid_google_services_json' => '유효하지 않은 JSON 파일입니다. 올바른 google-services.json 파일을 업로드하세요.',
        'invalid_google_services_structure' => '유효하지 않은 google-services.json입니다. 필수 project_info 또는 client 섹션이 없습니다.',
        'invalid_firebase_service_account' => '유효하지 않은 JSON 파일입니다. 올바른 Firebase 서비스 계정 파일을 업로드하세요.',
        'invalid_firebase_service_account_type' => '유효하지 않은 Firebase 서비스 계정 파일입니다. type 필드가 없거나 유효하지 않습니다.',
        'settings_save_failed_error' => '설정 저장 실패: :error',
        'file_delete_failed' => '파일 삭제 실패: :error',
        'credentials_delete_failed' => '자격 증명 삭제 실패: :error',
    ],

    // Editor Section Headers
    'sections' => [
        'general' => '일반',
        'general_description' => '기본 정보 및 설정',
        'design' => '디자인',
        'design_description' => '레이아웃, 색상, 테마 설정 커스터마이징',
        'icon' => '아이콘',
        'icon_description' => 'Android용 앱 아이콘 업로드',
        'splashscreen' => '스플래시 화면',
        'splashscreen_description' => '시작 화면 외관 및 애니메이션 구성',
        'navigation' => '내비게이션',
        'navigation_description' => '내비게이션 항목 및 앱 바 버튼 관리',
        'drawer' => '드로어 설정',
        'drawer_description' => '드로어 메뉴 외관 및 브랜딩 커스터마이징',
        'webview' => 'WebView 설정',
        'webview_description' => 'WebView 동작 및 기능 구성',
        'permissions' => '권한',
        'permissions_description' => '앱이 요청할 기기 권한 구성',
        'custom_code' => '커스텀 코드',
        'custom_code_description' => '앱에 커스텀 CSS 및 JavaScript 주입',
        'hosted_pages' => '호스팅 페이지',
        'hosted_pages_description' => '앱용 커스텀 HTML 페이지 생성 및 호스팅',
        'pages' => '페이지',
        'add_page' => '페이지 추가',
        'notifications' => '알림',
        'notifications_description' => '알림을 위한 Firebase Cloud Messaging 구성',
        'builds' => '빌드',
        'builds_description' => '배포를 위한 Android APK 및 AAB 파일 생성',
        'credits' => '크레딧',
        'new_build' => '새 빌드',
        'signing' => '서명',
        'signing_description' => '앱 배포를 위한 서명 키 관리',
        // WordPress-specific sections
        'general_description_wordpress' => '기본 정보 및 WordPress 사이트 설정',
        'content' => '콘텐츠',
        'content_description' => '포스트 표시 및 콘텐츠 설정 구성',
        'features' => '기능',
        'features_description' => '앱 기능 활성화 또는 비활성화',
    ],

];
