<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Platform Plugin Translation Strings
    |--------------------------------------------------------------------------
    |
    | The following language lines are used by the platform plugin blade
    | templates for settings and configuration pages.
    |
    */

    // General Settings
    'general' => [
        'basic_information' => 'المعلومات الأساسية',
        'basic_information_description' => 'التفاصيل الأساسية حول تطبيقك',
        'app_name' => 'اسم التطبيق',
        'app_name_placeholder' => 'تطبيقي الرائع',
        'app_name_help' => 'يظهر على الشاشة الرئيسية للجهاز',
        'website_url' => 'رابط الموقع الإلكتروني',
        'website_url_placeholder' => 'https://example.com',
        'website_url_help' => 'الرابط الكامل لموقعك أو تطبيقك الإلكتروني',
        'configuration' => 'الإعدادات',
        'configuration_description' => 'الإعدادات التقنية والمعرفات',
        'app_id' => 'معرف التطبيق',
        'app_id_tooltip' => 'معرف الحزمة الفريد المستخدم في متاجر التطبيقات',
        'app_id_placeholder' => 'com.example.app',
        'app_id_help' => 'لا يمكن تغيير معرف التطبيق بعد إنشائه',
        'copy' => 'نسخ',
        'copied' => 'تم النسخ!',
        'screen_orientation' => 'اتجاه الشاشة',
        'screen_orientation_help' => 'يتحكم في كيفية دوران تطبيقك على الجهاز',
        'orientation_system' => 'النظام',
        'orientation_portrait' => 'عمودي',
        'orientation_landscape' => 'أفقي',
        'app_language' => 'لغة التطبيق (رمز ISO)',
        'app_language_help' => 'اللغة الأساسية لمحتوى تطبيقك',
    ],

    // Design Settings
    'design' => [
        'layout_template' => 'قالب التخطيط',
        'layout_template_description' => 'اختر هيكل التنقل لتطبيقك',
        'layout_app_bar_drawer' => 'شريط التطبيق + القائمة الجانبية',
        'layout_app_bar_tabs' => 'شريط التطبيق + علامات التبويب',
        'layout_app_bar' => 'شريط التطبيق',
        'layout_blank' => 'فارغ',
        'progress_indicator' => 'مؤشر التقدم',
        'progress_indicator_help' => 'نمط مؤشر التحميل المعروض أثناء تحميل الصفحات',
        'progress_disable' => 'تعطيل',
        'progress_linear' => 'خطي',
        'progress_circular' => 'دائري',
        'progress_indicator_color' => 'لون مؤشر التقدم',
        'progress_indicator_color_help' => 'لون مؤشر تقدم التحميل',
        'show_app_bar_title' => 'عرض عنوان صفحة الويب الحالية في شريط التطبيق',
        'show_app_bar_title_help' => 'عرض عنوان الصفحة الحالية في الشريط العلوي',
        'nav_tab_icon_colors' => 'ألوان أيقونات علامات التبويب',
        'nav_tab_icon_colors_help' => 'لون أيقونات علامات التبويب غير النشطة في الوضع الفاتح والداكن',
        'active_tab_colors' => 'ألوان علامة التبويب النشطة',
        'active_tab_colors_help' => 'لون علامة التبويب المحددة في الوضع الفاتح والداكن',
        'light_mode' => 'الوضع الفاتح',
        'dark_mode' => 'الوضع الداكن',
        'theme_colors' => 'ألوان السمة',
        'theme_colors_description' => 'الألوان الأساسية التي تحدد مظهر تطبيقك',
        'theme_color' => 'لون السمة',
        'theme_color_help' => 'اللون الرئيسي المستخدم في جميع أنحاء تطبيقك',
        'enable_dynamic_colors' => 'تفعيل الألوان الديناميكية Material You (أندرويد 12+)',
        'enable_dynamic_colors_help' => 'عند التفعيل، سيتكيف تطبيقك مع ألوان خلفية المستخدم على أجهزة أندرويد 12 وما فوق. هذا يتجاوز لون السمة أعلاه.',
        'text_color_light' => 'لون النص (الوضع الفاتح)',
        'text_color_light_help' => 'لون النص والأيقونات الافتراضي في الوضع الفاتح',
        'text_color_dark' => 'لون النص (الوضع الداكن)',
        'text_color_dark_help' => 'لون النص والأيقونات الافتراضي في الوضع الداكن',
    ],

    // Icon Settings
    'icon' => [
        'app_icon' => 'أيقونة التطبيق',
        'app_icon_description' => 'ارفع أيقونة تطبيقك كملف ZIP من icon.kitchen',
        'current_icon' => 'الأيقونة الحالية',
        'icon_zip_uploaded' => 'تم رفع ملف ZIP للأيقونة',
        'icon_zip_uploaded_description' => 'الأيقونات المستخرجة متاحة لمنصات أندرويد والويب',
        'default_icon' => 'الأيقونة الافتراضية',
        'default_icon_description' => 'ارفع أيقونة مخصصة لاستبدال الافتراضية',
        'delete' => 'حذف',
        'upload_zip_file' => 'رفع ملف ZIP',
        'upload_zip_help' => 'ملف ZIP من icon.kitchen (الحد الأقصى 10 ميجابايت)',
        'how_to_create' => 'كيفية إنشاء أيقونتك:',
        'step_visit' => 'قم بزيارة',
        'step_design' => 'صمم أيقونة تطبيقك',
        'step_download' => 'قم بتنزيل ملف ZIP الذي يحتوي على جميع أيقونات المنصات',
        'step_upload' => 'ارفع ملف ZIP هنا',
        'zip_file_info' => 'يجب أن يحتوي ملف ZIP على أيقونات لمنصات أندرويد والويب (الحد الأقصى 10 ميجابايت)',
        'upload_icon' => 'رفع الأيقونة',
    ],

    // Splashscreen Settings
    'splashscreen' => [
        'appearance' => 'مظهر شاشة البداية',
        'appearance_description' => 'تخصيص الخلفية ومدة العرض وتأثيرات الحركة',
        'background_type' => 'نوع الخلفية',
        'background_type_color' => 'لون موحد',
        'background_type_image' => 'صورة خلفية',
        'background_color' => 'لون الخلفية',
        'background_image' => 'صورة الخلفية',
        'background_image_help' => 'PNG فقط (الحد الأقصى 2 ميجابايت)',
        'delete_background_image' => 'حذف صورة الخلفية',
        'display_duration' => 'مدة العرض:',
        'seconds' => 'ثواني',
        'animation_effect' => 'تأثير الحركة',
        'animation_fade' => 'تلاشي',
        'animation_slide' => 'انزلاق',
        'animation_zoom' => 'تكبير',
        'animation_none' => 'بدون',
        'branding' => 'العلامة التجارية لشاشة البداية',
        'branding_description' => 'أضف الشعار والعنوان والعنوان الفرعي وتنسيق النص لشاشة البداية',
        'show_logo' => 'عرض الشعار على شاشة البداية',
        'logo_image' => 'صورة الشعار',
        'logo_image_help' => 'يُنصح باستخدام PNG بخلفية شفافة (الحد الأقصى 2 ميجابايت)',
        'delete_logo' => 'حذف الشعار',
        'logo_size' => 'حجم الشعار:',
        'logo_size_small' => 'صغير (60dp)',
        'logo_size_medium' => 'متوسط (150dp)',
        'logo_size_large' => 'كبير (240dp)',
        'logo_size_help' => 'اضبط حجم الشعار للحصول على المظهر الأمثل',
        'title' => 'العنوان',
        'title_placeholder' => 'تطبيقي الرائع',
        'subtitle' => 'العنوان الفرعي',
        'subtitle_placeholder' => 'مرحباً بك في أفضل تطبيق على الإطلاق',
        'text_theme' => 'سمة النص',
        'text_theme_light' => 'فاتح (نص أبيض)',
        'text_theme_dark' => 'داكن (نص أسود)',
    ],

    // Drawer Settings
    'drawer' => [
        'appearance' => 'مظهر القائمة الجانبية',
        'appearance_description' => 'تخصيص الخلفية والنمط المرئي للقائمة الجانبية',
        'drawer_mode' => 'وضع القائمة الجانبية',
        'drawer_mode_help' => 'اختر كيفية ظهور خلفية القائمة الجانبية',
        'mode_default' => 'افتراضي (لون السمة)',
        'mode_color' => 'لون مخصص',
        'mode_image' => 'صورة خلفية',
        'background_color' => 'لون الخلفية',
        'background_color_help' => 'لون خلفية مخصص للقائمة الجانبية',
        'background_image' => 'صورة الخلفية',
        'background_image_help' => 'PNG فقط (الحد الأقصى 2 ميجابايت). الأبعاد الموصى بها: 1080×1920 بكسل',
        'delete_background_image' => 'حذف صورة الخلفية',
        'branding' => 'العلامة التجارية للقائمة الجانبية',
        'branding_description' => 'أضف الشعار والعنوان وخصص مظهر النص في رأس القائمة الجانبية',
        'show_logo' => 'عرض الشعار في القائمة الجانبية',
        'show_logo_help' => 'عرض شعار في رأس القائمة الجانبية',
        'logo_light' => 'شعار القائمة الجانبية (الوضع الفاتح)',
        'logo_light_help' => 'يُطلب PNG بخلفية شفافة (الحد الأقصى 2 ميجابايت) - يظهر عندما يكون التطبيق في السمة الفاتحة',
        'delete_light_logo' => 'حذف الشعار الفاتح',
        'logo_dark' => 'شعار القائمة الجانبية (الوضع الداكن)',
        'logo_dark_help' => 'يُطلب PNG بخلفية شفافة (الحد الأقصى 2 ميجابايت) - يظهر عندما يكون التطبيق في السمة الداكنة',
        'delete_dark_logo' => 'حذف الشعار الداكن',
        'logo_size' => 'حجم الشعار:',
        'logo_size_small' => 'صغير (40dp)',
        'logo_size_medium' => 'متوسط (120dp)',
        'logo_size_large' => 'كبير (200dp)',
        'logo_size_help' => 'اضبط حجم الشعار للحصول على المظهر الأمثل',
        'drawer_title' => 'عنوان القائمة الجانبية',
        'drawer_title_placeholder' => 'تطبيقي',
        'drawer_title_help' => 'العنوان المعروض في رأس القائمة الجانبية',
        'drawer_subtitle' => 'العنوان الفرعي للقائمة الجانبية',
        'drawer_subtitle_placeholder' => 'مرحباً بك في تطبيقي',
        'drawer_subtitle_help' => 'العنوان الفرعي أو الشعار المعروض أسفل العنوان',
        'text_theme' => 'سمة النص',
        'text_theme_help' => 'لون النص لرأس القائمة الجانبية وعناصر القائمة',
        'text_theme_light' => 'فاتح (نص أبيض)',
        'text_theme_dark' => 'داكن (نص أسود)',
        'item_colors' => 'ألوان عناصر القائمة الجانبية',
        'item_colors_description' => 'تخصيص ألوان الأيقونات والنص لعناصر قائمة القائمة الجانبية',
        'item_icon_colors' => 'ألوان أيقونات عناصر القائمة الجانبية',
        'item_icon_colors_help' => 'لون أيقونات ونص عناصر القائمة الجانبية غير النشطة في الوضع الفاتح والداكن',
        'active_item_colors' => 'ألوان العنصر النشط',
        'active_item_colors_help' => 'لون عنصر القائمة الجانبية المحدد/النشط في الوضع الفاتح والداكن',
        'light_mode' => 'الوضع الفاتح',
        'dark_mode' => 'الوضع الداكن',
    ],

    // Navigation Settings
    'navigation' => [
        'bottom_nav_bar' => 'شريط التنقل السفلي',
        'bottom_nav_bar_description' => 'تكوين عناصر علامات التبويب السفلية (الحد الأقصى 8 عناصر)',
        'add_item' => '+ إضافة عنصر',
        'no_navigation_items' => 'لا توجد عناصر تنقل مُكوّنة',
        'add_first_navigation_item' => 'أضف أول عنصر تنقل',
        'home_tab_badge' => 'علامة تبويب الرئيسية - متزامنة مع الرابط الرئيسي',
        'home_item_badge' => 'عنصر الرئيسية - متزامن مع الرابط الرئيسي',
        'label' => 'التسمية',
        'label_placeholder_home' => 'الرئيسية',
        'label_placeholder_about' => 'من نحن',
        'action_type' => 'نوع الإجراء',
        'action_internal' => 'رابط داخلي',
        'action_external' => 'رابط خارجي',
        'action_hosted_page' => 'صفحة مستضافة',
        'action_share' => 'مشاركة',
        'action_email' => 'إرسال بريد إلكتروني',
        'action_call' => 'إجراء مكالمة',
        'url' => 'الرابط',
        'email_address' => 'عنوان البريد الإلكتروني',
        'phone_number' => 'رقم الهاتف',
        'hosted_page' => 'صفحة مستضافة',
        'select_page' => 'اختر صفحة',
        'synced_from_general' => 'متزامن تلقائياً من الإعدادات العامة',
        'icon' => 'الأيقونة',
        'select_icon' => 'اختر أيقونة',
        'search_icons' => 'البحث عن أيقونات...',
        'home_tab_cannot_delete' => 'لا يمكن حذف علامة تبويب الرئيسية',
        'home_item_cannot_delete' => 'لا يمكن حذف عنصر الرئيسية',
        'max_navigation_items' => 'تم الوصول إلى الحد الأقصى وهو 8 عناصر تنقل (باستثناء علامة تبويب الرئيسية)',
        'app_bar_buttons' => 'أزرار شريط التطبيق',
        'app_bar_buttons_description' => 'إضافة أزرار إجراءات في أعلى يمين شريط التطبيق (الحد الأقصى 3 أزرار)',
        'add_button' => '+ إضافة زر',
        'no_app_bar_buttons' => 'لا توجد أزرار شريط تطبيق مُكوّنة',
        'add_first_app_bar_button' => 'أضف أول زر لشريط التطبيق',
        'max_app_bar_buttons' => 'تم الوصول إلى الحد الأقصى وهو 3 أزرار لشريط التطبيق',
        'drawer_menu_items' => 'عناصر قائمة القائمة الجانبية',
        'drawer_menu_items_description' => 'تكوين عناصر قائمة القائمة الجانبية (1 رئيسية + حتى 9 عناصر إضافية)',
        'no_drawer_items' => 'لا توجد عناصر قائمة جانبية مُكوّنة',
        'add_first_drawer_item' => 'أضف أول عنصر لقائمة القائمة الجانبية',
        'max_drawer_items' => 'تم الوصول إلى الحد الأقصى وهو 9 عناصر إضافية (10 إجمالاً بما في ذلك عنصر الرئيسية)',
        'behavior_settings' => 'إعدادات السلوك',
        'behavior_settings_description' => 'تكوين تفاعلات المستخدم',
        'pull_to_refresh' => 'السحب للتحديث',
        'pull_to_refresh_description' => 'السماح للمستخدمين بتحديث المحتوى عن طريق السحب للأسفل',
        'swipe_navigation' => 'التنقل بالسحب',
        'swipe_navigation_description' => 'السماح للمستخدمين بالعودة عن طريق السحب من الحافة',
        'swipe_navigation_disabled' => 'معطل لتخطيطات القائمة الجانبية لمنع تعارض الإيماءات',
        'preserve_tab_state' => 'الحفاظ على حالة علامة التبويب',
        'preserve_tab_state_description' => 'الاحتفاظ بالصفحة الحالية عند التبديل بين علامات التبويب/عناصر القائمة الجانبية',
    ],

    // Sidebar
    'sidebar' => [
        'app_settings' => 'إعدادات التطبيق',
        'general' => 'عام',
        'design' => 'التصميم',
        'icon' => 'الأيقونة',
        'splashscreen' => 'شاشة البداية',
        'navigation' => 'التنقل',
        'drawer' => 'القائمة الجانبية',
        'webview' => 'عرض الويب',
        'permissions' => 'الأذونات',
        'custom_code' => 'الكود المخصص',
        'hosted_pages' => 'الصفحات المستضافة',
        'notifications' => 'الإشعارات',
        'deployment' => 'النشر',
        'builds' => 'البناءات',
        'signing' => 'التوقيع',
        'back_to_apps' => 'العودة إلى التطبيقات',
    ],

    // WebView Settings
    'webview_user_agent_title' => 'وكيل المستخدم',
    'webview_user_agent_description' => 'تخصيص سلسلة وكيل مستخدم المتصفح',
    'webview_custom_user_agent' => 'وكيل مستخدم مخصص',
    'webview_user_agent_placeholder' => 'اتركه فارغاً لاستخدام وكيل مستخدم عرض الويب الافتراضي لأندرويد',
    'webview_user_agent_helper' => 'اختياري. تجاوز وكيل المستخدم الافتراضي المُرسل إلى موقعك.',
    'webview_features_title' => 'ميزات عرض الويب',
    'webview_features_description' => 'تكوين قدرات المتصفح وسلوكه',
    'webview_enable_javascript' => 'تفعيل JavaScript',
    'webview_enable_javascript_description' => 'السماح بتنفيذ JavaScript في عرض الويب',
    'webview_enable_dom_storage' => 'تفعيل تخزين DOM',
    'webview_enable_dom_storage_description' => 'السماح بواجهات برمجة التطبيقات localStorage و sessionStorage',
    'webview_enable_zoom_controls' => 'تفعيل عناصر التحكم في التكبير',
    'webview_enable_zoom_controls_description' => 'السماح بالتكبير بالقرص وعناصر التحكم في التكبير',
    'webview_enable_cache' => 'تفعيل التخزين المؤقت',
    'webview_enable_cache_description' => 'تخزين محتوى الويب مؤقتاً لتحميل أسرع',

    // Permissions Settings
    'permissions_location_title' => 'إذن الموقع',
    'permissions_location_description' => 'الوصول إلى GPS الجهاز للميزات المعتمدة على الموقع',
    'permissions_enable_location' => 'تفعيل الوصول إلى الموقع',
    'permissions_location_helper' => 'مطلوب للخرائط والمحتوى المعتمد على الموقع وميزات السياج الجغرافي.',
    'permissions_show_code_example' => 'عرض مثال الكود',
    'permissions_hide_code_example' => 'إخفاء مثال الكود',
    'permissions_javascript_example' => 'مثال JavaScript:',
    'permissions_camera_title' => 'إذن الكاميرا',
    'permissions_camera_description' => 'الوصول إلى كاميرا الجهاز للصور والفيديو',
    'permissions_enable_camera' => 'تفعيل الوصول إلى الكاميرا',
    'permissions_camera_helper' => 'مطلوب لالتقاط الصور ومسح رموز QR ومكالمات الفيديو.',
    'permissions_storage_title' => 'إذن التخزين',
    'permissions_storage_description' => 'الوصول إلى تخزين الجهاز لرفع وتنزيل الملفات',
    'permissions_enable_storage' => 'تفعيل الوصول إلى التخزين',
    'permissions_storage_helper' => 'مطلوب لرفع الملفات ومنتقي الصور وتنزيل الملفات.',
    'permissions_microphone_title' => 'إذن الميكروفون',
    'permissions_microphone_description' => 'الوصول إلى ميكروفون الجهاز لتسجيل الصوت',
    'permissions_enable_microphone' => 'تفعيل الوصول إلى الميكروفون',
    'permissions_microphone_helper' => 'مطلوب لتسجيل الصوت والمكالمات الصوتية والتعرف على الكلام.',
    'permissions_contacts_title' => 'إذن جهات الاتصال',
    'permissions_contacts_description' => 'الوصول إلى جهات اتصال الجهاز للميزات الاجتماعية',
    'permissions_enable_contacts' => 'تفعيل الوصول إلى جهات الاتصال',
    'permissions_contacts_helper' => 'مطلوب لمنتقي جهات الاتصال وميزات الدعوة والتكاملات الاجتماعية.',
    'permissions_vibrate_title' => 'إذن الاهتزاز',
    'permissions_vibrate_description' => 'الوصول إلى محرك اهتزاز الجهاز للردود اللمسية',
    'permissions_enable_vibrate' => 'تفعيل الاهتزاز',
    'permissions_vibrate_helper' => 'مطلوب للردود اللمسية واهتزازات الإشعارات.',

    // Custom Code Settings
    'custom_code_access_required_title' => 'الترقية مطلوبة',
    'custom_code_access_required_description' => 'خطتك الحالية لا تتضمن حقن الكود المخصص. قم بالترقية للوصول إلى هذه الميزة وإضافة CSS و JavaScript مخصصين لتطبيقك.',
    'custom_code_upgrade_plan' => 'قم بترقية خطتك',
    'custom_code_enable_feature' => 'لتفعيل هذه الميزة.',
    'custom_code_css_title' => 'CSS مخصص',
    'custom_code_css_description' => 'أضف أنماطاً مخصصة لتخصيص مظهر تطبيقك',
    'custom_code_css_label' => 'كود CSS',
    'custom_code_css_helper' => 'الحد الأقصى 100 كيلوبايت. سيتم حقن CSS في كل صفحة.',
    'custom_code_js_title' => 'JavaScript مخصص',
    'custom_code_js_description' => 'أضف نصوصاً برمجية مخصصة لوظائف موسعة',
    'custom_code_js_label' => 'كود JavaScript',
    'custom_code_js_helper' => 'الحد الأقصى 100 كيلوبايت. سيتم تنفيذ JavaScript في عرض الويب.',

    // Notifications Settings
    'notifications_title' => 'الإشعارات',
    'notifications_description' => 'تكوين Firebase Cloud Messaging (FCM) للإشعارات',
    'notifications_enable' => 'تفعيل الإشعارات',
    'notifications_firebase_service_account' => 'حساب خدمة Firebase',
    'notifications_firebase_service_account_description' => 'يستخدمه الخادم لإرسال الإشعارات عبر واجهة FCM API',
    'notifications_firebase_help_text' => 'ملف JSON (الحد الأقصى 2 ميجابايت)',
    'notifications_delete_firebase_credentials' => 'حذف بيانات اعتماد Firebase',
    'notifications_delete_firebase_credentials_confirm' => 'هل أنت متأكد أنك تريد حذف ملف بيانات اعتماد Firebase؟',
    'notifications_google_services' => 'خدمات Google',
    'notifications_google_services_description' => 'مطلوب لتكوين تطبيق أندرويد',
    'notifications_google_services_help_text' => 'ملف JSON (الحد الأقصى 1 ميجابايت)',
    'notifications_delete_google_services' => 'حذف ملف خدمات Google',
    'notifications_delete_google_services_confirm' => 'هل أنت متأكد أنك تريد حذف ملف خدمات Google؟',

    // Signing Keys Settings
    'signing_keys' => [
        'android_keystores' => 'مخازن مفاتيح أندرويد',
        'generate_new' => 'إنشاء جديد',
        'upload_existing' => 'رفع موجود',
        'default_badge' => 'افتراضي',
        'alias' => 'الاسم المستعار',
        'alias_placeholder' => 'my-key-alias',
        'auto_generated' => 'تم إنشاؤه تلقائياً',
        'created' => 'تاريخ الإنشاء',
        'set_as_default' => 'تعيين كافتراضي',
        'edit' => 'تعديل',
        'delete' => 'حذف',
        'no_keystores' => 'لا توجد مخازن مفاتيح أندرويد بعد. أنشئ مفتاحاً جديداً أو ارفع مفتاحاً موجوداً.',
        'upload_signing_key' => 'رفع مفتاح التوقيع',
        'android_keystore_upload' => 'رفع مخزن مفاتيح أندرويد',
        'keystore_name' => 'اسم مخزن المفاتيح',
        'keystore_name_placeholder' => 'مخزن مفاتيح الإصدار الخاص بي',
        'keystore_file' => 'ملف مخزن المفاتيح',
        'keystore_file_help' => 'ملف .jks أو .keystore أو .ks (الحد الأقصى 5 ميجابايت)',
        'upload_custom_key' => 'رفع مفتاح مخصص',
        'upload_custom_key_help' => 'ألغِ التحديد إذا كنت تستخدم مخزن مفاتيح تصحيح تم إنشاؤه تلقائياً',
        'password' => 'كلمة المرور',
        'password_placeholder' => '••••••••',
        'password_help' => 'يُستخدم للوصول إلى كل من مخزن المفاتيح والمفتاح',
        'cancel' => 'إلغاء',
        'upload' => 'رفع',
        'edit_keystore' => 'تعديل مخزن المفاتيح',
        'update_password' => 'تحديث كلمة المرور',
        'save' => 'حفظ',
        'delete_keystore' => 'حذف مخزن المفاتيح',
        'delete_confirmation' => 'هل أنت متأكد أنك تريد حذف',
        'action_cannot_be_undone' => 'لا يمكن التراجع عن هذا الإجراء.',

        // Keystore Generator Modal
        'generate_signing_key' => 'إنشاء مفتاح التوقيع',
        'generate_android_keystore' => 'إنشاء مخزن مفاتيح أندرويد',
        'generate_keystore_description' => 'سيتم إنشاء مخزن مفاتيح JKS جديد بشكل آمن على خادم البناء',
        'keystore_name_generate_placeholder' => 'مفتاح إصدار تطبيقي',
        'key_alias' => 'الاسم المستعار للمفتاح',
        'key_alias_placeholder' => 'my-app-key',
        'key_alias_help' => 'يجب أن يبدأ بحرف. الحروف والأرقام والشرطات والشرطات السفلية مسموح بها.',
        'password_settings' => 'إعدادات كلمة المرور',
        'keystore_password' => 'كلمة مرور مخزن المفاتيح',
        'min_characters_placeholder' => '6 أحرف على الأقل',
        'use_same_password' => 'استخدام نفس كلمة المرور للمفتاح ومخزن المفاتيح',
        'key_password' => 'كلمة مرور المفتاح',
        'validity_period' => 'فترة الصلاحية',
        'years_10' => '10 سنوات',
        'years_15' => '15 سنة',
        'years_20' => '20 سنة',
        'years_25_recommended' => '25 سنة (موصى به)',
        'years_30' => '30 سنة',
        'validity_help' => 'يتطلب Google Play صلاحية 25 سنة على الأقل للتطبيقات الجديدة',
        'certificate_details' => 'تفاصيل الشهادة (اختياري)',
        'common_name' => 'الاسم الشائع (CN)',
        'common_name_placeholder' => 'اسم تطبيقك أو مؤسستك',
        'organization' => 'المؤسسة (O)',
        'organization_placeholder' => 'اسم الشركة',
        'organizational_unit' => 'الوحدة التنظيمية (OU)',
        'organizational_unit_placeholder' => 'تطبيقات الجوال',
        'city' => 'المدينة (L)',
        'city_placeholder' => 'الرياض',
        'state' => 'المنطقة (ST)',
        'state_placeholder' => 'الرياض',
        'country' => 'الدولة (C)',
        'country_placeholder' => 'SA',
        'save_password_warning' => 'مهم: احفظ كلمة مرورك بشكل آمن!',
        'save_password_description' => 'سيتم تشفير مخزن المفاتيح وتخزينه. ستحتاج إلى كلمة المرور للبناءات المستقبلية. لا توجد طريقة لاستعادة كلمة مرور مفقودة.',
        'generating' => 'جارٍ الإنشاء...',
        'generate_keystore' => 'إنشاء مخزن المفاتيح',
    ],

    // Hosted Pages Settings
    'hosted_pages' => [
        'access_required' => 'الوصول إلى الصفحات المستضافة مطلوب',
        'upgrade_description' => 'خطتك الحالية لا تتضمن الصفحات المستضافة. قم بترقية خطتك لإنشاء صفحات مخصصة نستضيفها لك.',
        'upgrade_plan' => 'قم بترقية خطتك',
        'upgrade_suffix' => 'لتفعيل هذه الميزة.',
        'table_page' => 'الصفحة',
        'table_status' => 'الحالة',
        'table_created' => 'تاريخ الإنشاء',
        'table_actions' => 'الإجراءات',
        'status_published' => 'منشورة',
        'status_draft' => 'مسودة',
        'edit' => 'تعديل',
        'delete' => 'حذف',
        'no_pages' => 'لا توجد صفحات بعد',
        'no_pages_description' => 'انقر على "إضافة صفحة" لإنشاء أول صفحة مستضافة.',
    ],

    // Hosted Page Editor Modal
    'hosted_page_editor' => [
        'create_page' => 'إنشاء صفحة',
        'edit_page' => 'تعديل الصفحة',
        'title' => 'العنوان',
        'title_placeholder' => 'عنوان الصفحة',
        'slug' => 'المعرف',
        'slug_placeholder' => 'معرف-الصفحة',
        'start_from_template' => 'البدء من قالب',
        'status' => 'الحالة',
        'status_help' => 'الصفحات المنشورة فقط يمكن الوصول إليها في التطبيق',
        'cancel' => 'إلغاء',
        'save_changes' => 'حفظ التغييرات',
    ],

    // WordPress-specific Settings
    'wordpress' => [
        // General Settings
        'app_name_placeholder' => 'تطبيق ووردبريس الخاص بي',
        'wordpress_site_url' => 'رابط موقع ووردبريس',
        'wordpress_site_url_placeholder' => 'https://myblog.wordpress.com',
        'wordpress_site_url_help' => 'أدخل رابط موقع WordPress.com الخاص بك (مثال: myblog.wordpress.com)',
        'app_id_placeholder' => 'com.example.wordpress',
        'package_name_help' => 'معرف فريد بتنسيق النطاق المعكوس (مثال: com.company.wordpress). لا يمكن تغييره بعد الإنشاء.',

        // Design Settings
        'post_list_style' => 'نمط قائمة المقالات',
        'style_list' => 'قائمة',
        'style_grid' => 'شبكة',
        'style_magazine' => 'مجلة',
        'post_list_style_help' => 'كيفية عرض المقالات في التطبيق',
        'progress_indicator_help' => 'نمط مؤشر التحميل المعروض عند جلب المقالات',
        'show_app_bar_title' => 'عرض اسم التطبيق في شريط التطبيق',
        'show_app_bar_title_help' => 'عرض اسم تطبيقك في الشريط العلوي',
        'nav_tab_icon_colors_help' => 'لون أيقونات علامات التبويب غير النشطة',
        'active_tab_colors_help' => 'لون علامة التبويب المحددة',
        'theme_color_help' => 'اللون الرئيسي المستخدم في جميع أنحاء تطبيقك (أزرق ووردبريس: #21759B)',
        'dynamic_colors_help' => 'عند التفعيل، سيتكيف تطبيقك مع ألوان خلفية المستخدم على أجهزة أندرويد 12 وما فوق.',
        'layout_list_only' => 'قائمة فقط',

        // Splashscreen Settings
        'splashscreen_title_placeholder' => 'تطبيق ووردبريس الخاص بي',
        'splashscreen_subtitle_placeholder' => 'مرحباً بك في أفضل تطبيق مدونة على الإطلاق',

        // Sidebar
        'content' => 'المحتوى',
        'features' => 'الميزات',

        // Drawer Settings
        'drawer_appearance_description' => 'تخصيص خلفية القائمة الجانبية',
        'drawer_branding_description' => 'الشعار والعنوان وتنسيق النص',
        'logo_light_mode' => 'الشعار (الوضع الفاتح)',
        'logo_dark_mode' => 'الشعار (الوضع الداكن)',
        'png_transparency_help' => 'PNG بخلفية شفافة (الحد الأقصى 2 ميجابايت)',
        'delete_background' => 'حذف الخلفية',
        'drawer_title_placeholder' => 'تطبيق ووردبريس الخاص بي',
        'drawer_subtitle_placeholder' => 'شعارك هنا',
        'item_colors_description' => 'ألوان الأيقونات والنص لعناصر القائمة',
        'inactive_item_colors' => 'ألوان العناصر غير النشطة',

        // Navigation Settings
        'bottom_nav_tabs' => 'علامات التبويب السفلية',
        'bottom_nav_tabs_description' => 'تكوين عناصر التنقل السفلية (الحد الأقصى 8 + الرئيسية)',
        'add_tab' => '+ إضافة علامة تبويب',
        'home_tab_shows_all_posts' => 'علامة تبويب الرئيسية - تعرض جميع المقالات',
        'home_item_shows_all_posts' => 'عنصر الرئيسية - يعرض جميع المقالات',
        'tab_name_placeholder' => 'اسم علامة التبويب',
        'menu_item_placeholder' => 'عنصر القائمة',
        'action_category' => 'تصنيف',
        'action_tag' => 'وسم',
        'action_search' => 'بحث',
        'action_bookmarks' => 'المحفوظات',
        'action_share' => 'مشاركة',
        'category_slug' => 'معرف التصنيف',
        'tag_slug' => 'معرف الوسم',
        'category_slug_placeholder' => 'technology',
        'tag_slug_placeholder' => 'featured',
        'app_bar_buttons_description' => 'أزرار الإجراءات في أعلى اليمين (الحد الأقصى 3)',
        'no_app_bar_buttons_description' => 'لا توجد أزرار شريط تطبيق مُكوّنة. أضف البحث أو المشاركة أو إجراءات سريعة أخرى.',
        'search_placeholder' => 'بحث',
        'drawer_menu_items_description' => 'عناصر قائمة القائمة الجانبية (1 رئيسية + حتى 9 عناصر)',
        'swipe_navigation_description' => 'التنقل للخلف عن طريق السحب من الحافة',
        'preserve_tab_state_description' => 'الاحتفاظ بموضع التمرير عند التبديل بين علامات التبويب',

        // Content Settings
        'post_display' => 'عرض المقالات',
        'post_display_description' => 'تكوين كيفية عرض المقالات في تطبيقك',
        'posts_per_page' => 'المقالات لكل صفحة',
        'posts_per_page_help' => 'عدد المقالات المحملة في كل مرة (1-50)',
        'excerpt_length' => 'طول المقتطف (أحرف)',
        'excerpt_length_help' => 'الحد الأقصى للأحرف المعروضة في مقتطفات المقالات (50-500)',
        'post_metadata' => 'بيانات المقالة الوصفية',
        'post_metadata_description' => 'اختر المعلومات التي تريد عرضها مع كل مقالة',
        'show_featured_image' => 'عرض الصورة المميزة',
        'show_featured_image_help' => 'عرض الصورة المميزة/المصغرة للمقالة',
        'show_excerpt' => 'عرض مقتطف المقالة',
        'show_excerpt_help' => 'عرض معاينة لمحتوى المقالة',
        'show_author' => 'عرض اسم الكاتب',
        'show_author_help' => 'عرض الكاتب الذي كتب المقالة',
        'show_date' => 'عرض تاريخ النشر',
        'show_date_help' => 'عرض تاريخ نشر المقالة',
        'show_categories' => 'عرض التصنيفات',
        'show_categories_help' => 'عرض التصنيفات المخصصة للمقالة',
        'show_reading_time' => 'عرض وقت القراءة المقدر',
        'show_reading_time_help' => 'عرض المدة اللازمة لقراءة المقالة',

        // Features Settings
        'core_features' => 'الميزات الأساسية',
        'core_features_description' => 'تفعيل أو تعطيل وظائف التطبيق',
        'enable_search' => 'تفعيل البحث',
        'enable_search_help' => 'السماح للمستخدمين بالبحث عن المقالات في تطبيقك',
        'enable_comments' => 'تفعيل التعليقات',
        'enable_comments_help' => 'السماح للمستخدمين بعرض ونشر التعليقات على المقالات',
        'enable_bookmarks' => 'تفعيل المحفوظات',
        'enable_bookmarks_help' => 'السماح للمستخدمين بحفظ المقالات للقراءة لاحقاً',
        'enable_share' => 'تفعيل المشاركة',
        'enable_share_help' => 'السماح للمستخدمين بمشاركة المقالات عبر تطبيقات أخرى',
        'advanced_features' => 'الميزات المتقدمة',
        'advanced_features_description' => 'وظائف إضافية لتجربة مستخدم محسّنة',
        'enable_offline_reading' => 'تفعيل القراءة بدون اتصال',
        'enable_offline_reading_help' => 'تخزين المقالات مؤقتاً للقراءة بدون اتصال بالإنترنت',
        'enable_user_auth' => 'تفعيل مصادقة المستخدم',
        'enable_user_auth_help' => 'السماح للمستخدمين بتسجيل الدخول بحساب WordPress.com الخاص بهم',
        'enable_push_notifications' => 'تفعيل الإشعارات الفورية',
        'enable_push_notifications_help' => 'إرسال إشعارات عند نشر مقالات جديدة',
    ],

    // Builds
    'builds' => [
        // Builds Table
        'search_placeholder' => 'البحث في البناءات...',
        'filter' => 'تصفية',
        'platform_filter' => 'المنصة',
        'status_filter' => 'الحالة',
        'android' => 'أندرويد',
        'completed' => 'مكتمل',
        'building' => 'جارٍ البناء',
        'failed' => 'فشل',
        'pending' => 'قيد الانتظار',
        'table_platform' => 'المنصة',
        'table_build_info' => 'معلومات البناء',
        'table_created' => 'تاريخ الإنشاء',
        'table_actions' => 'الإجراءات',
        'release' => 'إصدار',
        'debug' => 'تصحيح',
        'download' => 'تنزيل',
        'preview' => 'معاينة',
        'logs' => 'السجلات',
        'delete' => 'حذف',
        'no_builds' => 'لا توجد بناءات',

        // Build Modal
        'create_new_build' => 'إنشاء بناء جديد',
        'platform_label' => 'المنصة',
        'build_costs_credit' => 'تكلفة البناء :count رصيد|تكلفة البناء :count أرصدة',
        'build_type_label' => 'نوع البناء',
        'for_testing' => 'للاختبار',
        'for_production' => 'للإنتاج',
        'output_format_label' => 'صيغة المخرجات',
        'apk' => 'APK',
        'aab' => 'AAB',
        'for_testing_sideloading' => 'للاختبار/التثبيت الجانبي',
        'for_google_play_store' => 'لمتجر Google Play',
        'builder_label' => 'خادم البناء',
        'auto_select_recommended' => 'اختيار تلقائي (موصى به)',
        'auto_select_help' => 'اترك "اختيار تلقائي" لاستخدام أقل خادم بناء انشغالاً، أو اختر خادم بناء محدد.',
        'no_builders_available' => 'لا تتوفر خوادم بناء!',
        'no_builders_help' => 'خطتك لا تتضمن الوصول إلى أي خوادم بناء. يرجى التواصل مع الدعم أو ترقية خطتك.',
        'signing_key_label' => 'مفتاح التوقيع',
        'select_keystore' => 'اختر مخزن مفاتيح',
        'no_keystores_available' => 'لا تتوفر مخازن مفاتيح.',
        'upload_in_signing_section' => 'ارفع واحداً في قسم التوقيع',
        'signing_key_required' => 'مفتاح التوقيع مطلوب!',
        'version_name_label' => 'اسم الإصدار',
        'version_name_help' => 'التنسيق: X.Y أو X.Y.Z (مثال: 1.0 أو 1.0.0). يزداد تلقائياً لكل منصة.',
        'build_number_label' => 'رقم البناء',
        'next_build_number' => 'رقم البناء التالي',
        'build_number_auto_increment' => 'رقم البناء يزداد تلقائياً مع كل بناء',
        'build_cost_info' => 'هذا البناء سيكلف :count رصيد|هذا البناء سيكلف :count أرصدة',
        'build_email_notification' => 'ستتلقى بريداً إلكترونياً عندما يكون البناء جاهزاً للتنزيل.',
        'cancel' => 'إلغاء',
        'start_build' => 'بدء البناء',
        'credit' => 'رصيد',
        'credits' => 'أرصدة',
        'builder_info' => 'خادم البناء:',

        // Build Logs Modal
        'build_logs' => 'سجلات البناء',
        'duration' => 'المدة:',
        'no_logs_available' => 'لا تتوفر سجلات لهذا البناء',
        'error' => 'خطأ:',
        'close' => 'إغلاق',
        'download_build' => 'تنزيل البناء',

        // Build Download Modal
        'download_build_title' => 'تنزيل البناء',
        'aab_title' => 'حزمة تطبيق أندرويد (AAB)',
        'aab_description' => 'هذا ملف AAB لا يمكن تثبيته مباشرة على الأجهزة. ملفات AAB مصممة للرفع إلى Google Play Console، حيث ستقوم Google بإنشاء ملفات APK محسّنة للمستخدمين.',
        'scan_with_android' => 'امسح باستخدام جهاز أندرويد',
        'qr_unavailable' => 'رمز QR غير متوفر',
        'download_options' => 'خيارات التنزيل',
        'download_options_description' => 'امسح رمز QR بجهازك المحمول أو استخدم رابط التنزيل المباشر أدناه.',
        'download_format' => 'تنزيل :format',
        'installation_note' => 'التثبيت:',
        'installation_help' => 'قد تحتاج إلى تفعيل "التثبيت من مصادر غير معروفة" في إعدادات أندرويد.',
        'download_aab_file' => 'تنزيل ملف AAB',
        'upload_to_play_console' => 'ارفع هذا الملف إلى Google Play Console لنشر تطبيقك.',
        'next_steps' => 'الخطوات التالية:',
        'next_steps_help' => 'ارفع ملف AAB هذا إلى Google Play Console ضمن الإصدار > الإنتاج/الاختبار. ستقوم Google تلقائياً بإنشاء ملفات APK محسّنة لمستخدميك.',

        // Delete Build Modal
        'delete_build' => 'حذف البناء',
        'delete_confirmation' => 'هل أنت متأكد أنك تريد حذف',
        'build_suffix' => 'البناء؟',
        'action_cannot_be_undone' => 'لا يمكن التراجع عن هذا الإجراء.',
    ],

    // App Preview Panel
    'preview' => [
        'no_build_selected' => 'لم يتم اختيار بناء',
        'select_build_help' => 'اختر بناءً مكتملاً من علامة تبويب البناءات لمعاينته هنا',
    ],

    // App Creation Form
    'creation' => [
        'website_url' => 'رابط الموقع الإلكتروني',
        'app_id' => 'معرف التطبيق',
        'app_id_tooltip' => 'معرف الحزمة الفريد (لا يمكن تغييره بعد الإنشاء)',
        'auto_generate_package' => 'إنشاء تلقائي من اسم التطبيق',
        'package_name_help' => 'معرف فريد بتنسيق النطاق المعكوس (مثال: com.company.app). لا يمكن تغييره بعد الإنشاء.',
        'theme_color' => 'لون السمة',
        'theme_color_help' => 'اللون الرئيسي المستخدم في جميع أنحاء تطبيقك. ألوان النص ستستخدم الأسود/الأبيض الافتراضي ويمكن تخصيصها لاحقاً.',
        'layout_template' => 'قالب التخطيط',
        'layout_app_bar_drawer' => 'شريط التطبيق + القائمة الجانبية',
        'layout_app_bar_tabs' => 'شريط التطبيق + علامات التبويب',
        'layout_app_bar' => 'شريط التطبيق',
        'layout_blank' => 'فارغ',
        'layout_help' => 'اختر هيكل التنقل لتطبيقك',
    ],

    // Delete Modals
    'modals' => [
        'cancel' => 'إلغاء',
        'delete' => 'حذف',
        'action_cannot_be_undone' => 'لا يمكن التراجع عن هذا الإجراء.',
        'delete_build' => 'حذف البناء',
        'delete_build_confirmation' => 'هل أنت متأكد أنك تريد حذف',
        'build_suffix' => 'البناء؟',
        'delete_app_icon' => 'حذف أيقونة التطبيق',
        'delete_icon_confirmation' => 'هل أنت متأكد أنك تريد حذف أيقونة',
        'delete_keystore' => 'حذف مخزن المفاتيح',
        'delete_keystore_confirmation' => 'هل أنت متأكد أنك تريد حذف',
        'delete_splashscreen_background' => 'حذف خلفية شاشة البداية',
        'delete_splashscreen_background_confirmation' => 'هل أنت متأكد أنك تريد حذف صورة خلفية شاشة البداية لـ',
        'delete_splashscreen_logo' => 'حذف شعار شاشة البداية',
        'delete_splashscreen_logo_confirmation' => 'هل أنت متأكد أنك تريد حذف شعار شاشة البداية لـ',
        'delete_drawer_background' => 'حذف خلفية القائمة الجانبية',
        'delete_drawer_background_confirmation' => 'هل أنت متأكد أنك تريد حذف صورة خلفية القائمة الجانبية لـ',
        'delete_dark_mode_logo' => 'حذف شعار الوضع الداكن',
        'delete_dark_mode_logo_confirmation' => 'هل أنت متأكد أنك تريد حذف شعار الوضع الداكن للقائمة الجانبية لـ',
        'delete_light_mode_logo' => 'حذف شعار الوضع الفاتح',
        'delete_light_mode_logo_confirmation' => 'هل أنت متأكد أنك تريد حذف شعار الوضع الفاتح للقائمة الجانبية لـ',
        'delete_page' => 'حذف الصفحة',
        'delete_page_confirmation' => 'هل أنت متأكد أنك تريد حذف',
        'delete_page_warning' => 'لا يمكن التراجع عن هذا الإجراء. إذا كانت هذه الصفحة مستخدمة في التنقل، فلن يمكن الوصول إليها بعد الآن.',
    ],

    // WordPress Notifications Settings
    'notifications_wp' => [
        'title' => 'الإشعارات الفورية',
        'description' => 'تكوين Firebase Cloud Messaging للإشعارات الفورية',
        'enable_label' => 'تفعيل الإشعارات الفورية',
        'enable_help' => 'إرسال إشعارات عند نشر مقالات جديدة',
        'firebase_required_title' => 'تكوين Firebase مطلوب',
        'firebase_required_description' => 'ارفع ملفي التكوين أدناه لتفعيل الإشعارات الفورية في تطبيقك.',
        'google_services_label' => 'google-services.json',
        'file_uploaded' => 'تم رفع الملف',
        'google_services_configured' => 'تم تكوين google-services.json',
        'delete' => 'حذف',
        'delete_file_confirm' => 'هل أنت متأكد أنك تريد حذف هذا الملف؟',
        'upload_google_services' => 'رفع google-services.json',
        'google_services_help' => 'قم بالتنزيل من Firebase Console (الحد الأقصى 1 ميجابايت)',
        'google_services_instructions' => 'قم بالتنزيل من Firebase Console > إعدادات المشروع > تطبيقاتك > تطبيق أندرويد',
        'firebase_service_account_label' => 'حساب خدمة Firebase (لإرسال الإشعارات)',
        'credentials_configured' => 'تم تكوين بيانات الاعتماد',
        'service_account_stored' => 'حساب الخدمة مُخزّن بشكل آمن',
        'delete_credentials_confirm' => 'هل أنت متأكد أنك تريد حذف بيانات الاعتماد هذه؟',
        'upload_service_account' => 'رفع ملف JSON لحساب الخدمة',
        'service_account_help' => 'قم بالتنزيل من Firebase Console (الحد الأقصى 2 ميجابايت)',
        'service_account_instructions' => 'قم بالتنزيل من Firebase Console > إعدادات المشروع > حسابات الخدمة > إنشاء مفتاح خاص جديد',
        'setup_title' => 'كيفية إعداد Firebase:',
        'setup_step_1' => 'اذهب إلى',
        'setup_step_2' => 'أنشئ مشروعاً أو اختر مشروعاً موجوداً',
        'setup_step_3' => 'أضف تطبيق أندرويد باسم الحزمة الخاص بك:',
        'setup_step_4' => 'قم بتنزيل',
        'setup_step_4_suffix' => 'وارفعه أعلاه',
        'setup_step_5' => 'اذهب إلى إعدادات المشروع > حسابات الخدمة',
        'setup_step_6' => 'أنشئ مفتاحاً خاصاً جديداً وارفعه أعلاه',
    ],

    // Toast Messages - Settings
    'toast' => [
        // General success/error
        'settings_saved' => 'تم حفظ إعدادات :section بنجاح!',
        'settings_save_failed' => 'فشل حفظ الإعدادات. يرجى المحاولة مرة أخرى.',

        // Design settings
        'design_saved' => 'تم حفظ إعدادات التصميم بنجاح!',

        // Navigation settings
        'navigation_saved' => 'تم حفظ إعدادات التنقل بنجاح!',
        'home_tab_cannot_delete' => 'لا يمكن حذف علامة الرئيسية. إنها مطلوبة للتنقل.',
        'home_tab_cannot_move' => 'يجب أن تبقى علامة الرئيسية في المقدمة ولا يمكن نقلها.',
        'cannot_move_below_home' => 'لا يمكن نقل العناصر أسفل علامة الرئيسية.',
        'home_item_cannot_delete' => 'لا يمكن حذف عنصر الرئيسية. إنه مطلوب للتنقل.',
        'home_item_cannot_move' => 'يجب أن يبقى عنصر الرئيسية في المقدمة ولا يمكن نقله.',
        'cannot_move_below_home_item' => 'لا يمكن نقل العناصر أسفل عنصر الرئيسية.',

        // Custom code
        'custom_code_saved' => 'تم حفظ الكود المخصص بنجاح!',
        'custom_code_save_failed' => 'فشل حفظ الكود المخصص. يرجى المحاولة مرة أخرى.',
        'custom_code_no_access' => 'خطتك لا تتضمن الوصول إلى الكود المخصص. يرجى ترقية خطتك.',

        // WebView settings
        'webview_saved' => 'تم حفظ إعدادات WebView بنجاح!',

        // Permissions settings
        'permissions_saved' => 'تم حفظ الأذونات بنجاح!',

        // Drawer settings
        'drawer_saved' => 'تم حفظ إعدادات القائمة الجانبية بنجاح!',

        // General settings
        'general_saved' => 'تم حفظ الإعدادات العامة بنجاح!',

        // Splashscreen settings
        'splashscreen_saved' => 'تم حفظ إعدادات شاشة البداية بنجاح!',

        // Icon settings
        'icon_uploaded' => 'تم رفع أيقونة التطبيق بنجاح!',
        'icon_upload_failed' => 'فشل رفع الأيقونة: :error',
        'icon_removed' => 'تمت إزالة أيقونة التطبيق بنجاح!',
        'icon_remove_failed' => 'فشلت إزالة الأيقونة. يرجى المحاولة مرة أخرى.',

        // Splashscreen modals
        'splashscreen_background_deleted' => 'تم حذف صورة خلفية شاشة البداية بنجاح!',
        'splashscreen_background_delete_failed' => 'فشل حذف صورة الخلفية. يرجى المحاولة مرة أخرى.',
        'splashscreen_logo_deleted' => 'تم حذف شعار شاشة البداية بنجاح!',
        'splashscreen_logo_delete_failed' => 'فشل حذف الشعار. يرجى المحاولة مرة أخرى.',

        // Drawer modals
        'drawer_background_deleted' => 'تم حذف صورة خلفية القائمة الجانبية بنجاح!',
        'drawer_background_delete_failed' => 'فشل حذف صورة الخلفية. يرجى المحاولة مرة أخرى.',
        'drawer_logo_deleted' => 'تم حذف شعار القائمة الجانبية بنجاح!',
        'drawer_logo_delete_failed' => 'فشل حذف الشعار. يرجى المحاولة مرة أخرى.',
        'drawer_logo_light_deleted' => 'تم حذف شعار الوضع الفاتح للقائمة الجانبية بنجاح!',
        'drawer_logo_dark_deleted' => 'تم حذف شعار الوضع الداكن للقائمة الجانبية بنجاح!',

        // Notifications settings
        'notifications_saved' => 'تم حفظ إعدادات الإشعارات بنجاح!',
        'firebase_credentials_deleted' => 'تم حذف بيانات اعتماد Firebase بنجاح!',
        'firebase_credentials_delete_failed' => 'فشل حذف بيانات اعتماد Firebase. يرجى المحاولة مرة أخرى.',
        'google_services_deleted' => 'تم حذف ملف Google Services بنجاح!',
        'google_services_delete_failed' => 'فشل حذف ملف Google Services. يرجى المحاولة مرة أخرى.',

        // Signing keys
        'keystore_updated' => 'تم تحديث مخزن المفاتيح بنجاح!',
        'keystore_update_failed' => 'فشل تحديث مخزن المفاتيح.',
        'keystore_load_failed' => 'فشل تحميل مخزن المفاتيح.',
        'keystore_deleted' => 'تم حذف مخزن المفاتيح بنجاح!',
        'keystore_delete_failed' => 'فشل حذف مخزن المفاتيح. يرجى المحاولة مرة أخرى.',
        'keystore_uploaded' => 'تم رفع مخزن المفاتيح بنجاح!',
        'keystore_upload_failed' => 'فشل رفع مفتاح التوقيع: :error',
        'keystore_generated' => 'تم إنشاء مخزن المفاتيح بنجاح!',
        'keystore_set_default' => 'تم تحديث مخزن المفاتيح الافتراضي بنجاح!',

        // Build modal
        'build_no_builders_platform' => 'لا توجد بنّاءات متاحة لمنصة :platform. يرجى التواصل مع الدعم أو ترقية خطتك.',
        'build_no_subscription' => 'تحتاج إلى اشتراك نشط لبناء التطبيقات. يرجى الاشتراك في خطة.',
        'build_no_builders_plan' => 'لا توجد بنّاءات متاحة لخطتك. يرجى التواصل مع الدعم أو ترقية خطتك.',
        'build_builder_not_available' => 'البنّاء المحدد غير متاح لخطتك.',
        'build_builder_unavailable' => 'البنّاء المحدد غير متاح حالياً.',
        'build_builder_no_platform' => 'البنّاء المحدد لا يدعم منصة :platform.',
        'build_insufficient_credits' => 'رصيد البناء غير كافٍ. يتطلب هذا البناء :count رصيداً. يرجى ترقية خطتك أو انتظار إعادة التعيين الشهرية.',
        'build_keystore_required' => 'مخزن مفاتيح أندرويد مطلوب لبناء الإصدار. يرجى اختيار مخزن مفاتيح.',
        'build_keystore_invalid' => 'مخزن المفاتيح المحدد غير صالح.',
        'build_already_in_progress' => 'بناء :platform قيد التنفيذ بالفعل. يرجى الانتظار حتى اكتماله.',
        'build_queued' => 'تم وضع بناء :platform في قائمة الانتظار بنجاح! سيتم معالجة بنائك عندما يتوفر بنّاء. (:credits رصيد متبقي)',
        'build_queued_on_builder' => 'تم وضع بناء :platform في قائمة الانتظار بنجاح على :builder! (:credits رصيد متبقي)',
        'build_create_failed' => 'فشل إنشاء البناء: :error',
        'build_deleted' => 'تم حذف البناء بنجاح!',
        'build_delete_failed' => 'فشل حذف البناء. يرجى المحاولة مرة أخرى.',

        // Hosted pages
        'hosted_page_saved' => 'تم حفظ الصفحة بنجاح!',
        'hosted_page_save_failed' => 'فشل حفظ الصفحة. يرجى المحاولة مرة أخرى.',
        'hosted_page_deleted' => 'تم حذف الصفحة بنجاح!',
        'hosted_page_delete_failed' => 'فشل حذف الصفحة. يرجى المحاولة مرة أخرى.',
        'hosted_page_limit_reached' => 'لقد وصلت إلى الحد الأقصى لعدد الصفحات المستضافة لخطتك.',
        'hosted_page_no_access' => 'خطتك الحالية لا تتضمن الصفحات المستضافة. قم بترقية خطتك لإنشاء صفحات مخصصة.',

        // Additional toast keys for AndroidWordPress
        'features_saved' => 'تم حفظ إعدادات الميزات بنجاح!',
        'content_saved' => 'تم حفظ إعدادات المحتوى بنجاح!',
        'storage_link_missing' => 'لم يتم العثور على رابط التخزين. قم بتشغيل: php artisan storage:link',
        'splashscreen_image_deleted' => 'تم حذف صورة خلفية شاشة البداية بنجاح!',
        'splashscreen_image_delete_failed' => 'فشل حذف صورة الخلفية. يرجى المحاولة مرة أخرى.',
        'logo_delete_failed' => 'فشل حذف الشعار. يرجى المحاولة مرة أخرى.',
        'default_key_updated' => 'تم تحديث مفتاح التوقيع الافتراضي بنجاح!',
        'default_key_update_failed' => 'فشل تحديث مفتاح التوقيع الافتراضي.',
        'keystore_uploaded_default' => 'تم رفع مخزن المفاتيح وتعيينه كافتراضي!',
        'signing_key_upload_failed' => 'فشل رفع مفتاح التوقيع: :error',
        'page_not_found' => 'الصفحة غير موجودة.',
        'page_deleted' => 'تم حذف الصفحة بنجاح!',
        'page_delete_failed' => 'فشل حذف الصفحة. يرجى المحاولة مرة أخرى.',
        'page_updated' => 'تم تحديث الصفحة بنجاح!',
        'page_created' => 'تم إنشاء الصفحة بنجاح!',
        'page_save_failed' => 'فشل حفظ الصفحة. يرجى المحاولة مرة أخرى.',
        'page_limit_reached' => 'لقد وصلت إلى الحد الأقصى :max صفحة لخطتك.',
        'hosted_pages_not_available' => 'خطتك لا تتضمن الصفحات المستضافة. يرجى ترقية خطتك.',
        'unauthorized' => 'إجراء غير مصرح به.',
        'home_tab_required' => 'لا يمكن حذف علامة الرئيسية. إنها مطلوبة للتنقل.',
        'home_tab_first' => 'يجب أن تبقى علامة الرئيسية أولاً.',
        'home_item_required' => 'لا يمكن حذف عنصر الرئيسية.',
        'build_no_builders' => 'لا توجد بنّاءات متاحة لمنصة :platform. يرجى التواصل مع الدعم أو ترقية خطتك.',
        'build_no_plan_builders' => 'لا توجد بنّاءات متاحة لخطتك. يرجى التواصل مع الدعم أو ترقية خطتك.',
        'build_builder_platform_unsupported' => 'البنّاء المحدد لا يدعم منصة :platform.',
        'build_insufficient_credits' => 'رصيد البناء غير كافٍ. يتطلب هذا البناء :credits رصيداً. يرجى ترقية خطتك أو انتظار إعادة التعيين الشهرية.',
        'build_invalid_keystore' => 'مخزن المفاتيح المحدد غير صالح.',
        'build_queued_no_builder' => 'تم وضع بناء :platform في قائمة الانتظار بنجاح! سيتم معالجة بنائك عندما يتوفر بنّاء. (:credits رصيد متبقي)',
        'build_queued_success' => 'تم وضع بناء :platform في قائمة الانتظار بنجاح على :builder! (:credits رصيد متبقي)',
        'available_builder' => 'بنّاء متاح',
        'invalid_google_services_json' => 'ملف JSON غير صالح. يرجى رفع ملف google-services.json صالح.',
        'invalid_google_services_structure' => 'ملف google-services.json غير صالح. يفتقر إلى قسم project_info أو client المطلوب.',
        'invalid_firebase_service_account' => 'ملف JSON غير صالح. يرجى رفع ملف حساب خدمة Firebase صالح.',
        'invalid_firebase_service_account_type' => 'ملف حساب خدمة Firebase غير صالح. حقل النوع مفقود أو غير صالح.',
        'settings_save_failed_error' => 'فشل حفظ الإعدادات: :error',
        'file_delete_failed' => 'فشل حذف الملف: :error',
        'credentials_delete_failed' => 'فشل حذف بيانات الاعتماد: :error',
    ],

    // Editor Section Headers
    'sections' => [
        'general' => 'عام',
        'general_description' => 'المعلومات الأساسية وإعدادات التكوين',
        'design' => 'التصميم',
        'design_description' => 'تخصيص التخطيط والألوان وإعدادات السمة',
        'icon' => 'الأيقونة',
        'icon_description' => 'رفع أيقونة التطبيق لأندرويد',
        'splashscreen' => 'شاشة البداية',
        'splashscreen_description' => 'تكوين مظهر شاشة البدء والحركة',
        'navigation' => 'التنقل',
        'navigation_description' => 'إدارة عناصر التنقل وأزرار شريط التطبيق',
        'drawer' => 'إعدادات القائمة الجانبية',
        'drawer_description' => 'تخصيص مظهر قائمة القائمة الجانبية والعلامة التجارية',
        'webview' => 'إعدادات عرض الويب',
        'webview_description' => 'تكوين سلوك عرض الويب وميزاته',
        'permissions' => 'الأذونات',
        'permissions_description' => 'تكوين أذونات الجهاز التي سيطلبها تطبيقك',
        'custom_code' => 'الكود المخصص',
        'custom_code_description' => 'حقن CSS و JavaScript مخصصين في تطبيقك',
        'hosted_pages' => 'الصفحات المستضافة',
        'hosted_pages_description' => 'إنشاء صفحات HTML مخصصة نستضيفها لتطبيقك',
        'pages' => 'الصفحات',
        'add_page' => 'إضافة صفحة',
        'notifications' => 'الإشعارات',
        'notifications_description' => 'تكوين Firebase Cloud Messaging للإشعارات',
        'builds' => 'البناءات',
        'builds_description' => 'إنشاء ملفات APK و AAB لأندرويد للنشر',
        'credits' => 'الأرصدة',
        'new_build' => 'بناء جديد',
        'signing' => 'التوقيع',
        'signing_description' => 'إدارة مفاتيح التوقيع لتوزيع التطبيق',
        // WordPress-specific sections
        'general_description_wordpress' => 'المعلومات الأساسية وتكوين موقع ووردبريس',
        'content' => 'المحتوى',
        'content_description' => 'تكوين عرض المقالات وإعدادات المحتوى',
        'features' => 'الميزات',
        'features_description' => 'تفعيل أو تعطيل ميزات التطبيق',
    ],

];
