<?php

namespace Database\Seeders;

use App\Models\Plugin;
use Illuminate\Database\Seeder;

class PlatformPluginsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Core platform plugins (always installed)
        $plugins = [
            [
                'name' => 'Android WebView',
                'slug' => 'android-webview',
                'type' => 'platform',
                'class' => 'App\Plugins\Platforms\AndroidWebView\AndroidWebViewPlatform',
                'version' => '1.0.0',
                'status' => 'active',
                'config' => null,
                'migrations' => [
                    '2025_11_21_145300_create_android_webview_configs_table.php',
                    '2025_11_24_000000_update_text_color_fields_in_android_webview_configs.php',
                    '2025_11_24_163205_split_tab_colors_light_dark_in_android_webview_configs.php',
                    '2025_12_24_000004_create_app_pages_table.php',
                ],
                'metadata' => json_decode(file_get_contents(app_path('Plugins/Platforms/AndroidWebView/plugin.json')), true),
                'installed_at' => now(),
            ],
        ];

        // Development platform plugins (local environment only)
        if (app()->environment('local')) {
            $plugins[] = [
                'name' => 'Android WordPress',
                'slug' => 'android-wordpress',
                'type' => 'platform',
                'class' => 'App\Plugins\Platforms\AndroidWordPress\AndroidWordPressPlatform',
                'version' => '1.0.0',
                'status' => 'active',
                'config' => null,
                'migrations' => [
                    '2025_12_26_000000_create_android_wordpress_configs_table.php',
                    '2025_12_26_000001_create_app_pages_table_if_not_exists.php',
                ],
                'metadata' => json_decode(file_get_contents(app_path('Plugins/Platforms/AndroidWordPress/plugin.json')), true),
                'installed_at' => now(),
            ];
        }

        foreach ($plugins as $pluginData) {
            Plugin::updateOrCreate(
                ['slug' => $pluginData['slug']],
                $pluginData
            );

            $this->command->info("Installed platform: {$pluginData['name']}");
        }
    }
}
