<?php

namespace App\Livewire;

use App\Services\ImpersonationService;
use Livewire\Component;

class ImpersonationBanner extends Component
{
    public bool $isImpersonating = false;

    public ?string $impersonatedUserName = null;

    public ?string $adminName = null;

    public function mount(): void
    {
        $service = app(ImpersonationService::class);

        $this->isImpersonating = $service->isImpersonating();

        if ($this->isImpersonating) {
            $this->impersonatedUserName = auth()->user()?->name;
            $this->adminName = $service->getImpersonator()?->name;
        }
    }

    public function stopImpersonation()
    {
        return redirect()->route('admin.impersonate.stop');
    }

    public function render()
    {
        return view('livewire.impersonation-banner');
    }
}
