<?php

namespace App\Livewire\Admin;

use App\Models\Plugin;
use App\Services\PluginManager;
use Livewire\Attributes\On;
use Livewire\Component;

class DeletePluginModal extends Component
{
    public $showModal = false;

    public $pluginId;

    public $pluginName;

    #[On('delete-plugin')]
    public function open($id)
    {
        $plugin = Plugin::findOrFail($id);

        $this->pluginId = $id;
        $this->pluginName = $plugin->name;
        $this->showModal = true;
    }

    public function delete()
    {
        if (config('app.demo')) {
            $this->dispatch('show-toast',
                type: 'error',
                message: __('common.demo_mode_plugin_disabled')
            );
            $this->close();

            return;
        }

        try {
            $plugin = Plugin::findOrFail($this->pluginId);

            // Prevent uninstalling core platform plugins
            if ($plugin->slug === 'android-webview') {
                $this->dispatch('show-toast',
                    type: 'error',
                    message: __('common.cannot_uninstall_core_plugin')
                );
                $this->close();

                return;
            }

            $pluginManager = app(PluginManager::class);

            $pluginManager->uninstall($plugin);

            $this->dispatch('show-toast',
                type: 'success',
                message: __('common.plugin_uninstalled')
            );

            $this->dispatch('plugin-deleted');
            $this->close();
        } catch (\Exception $e) {
            $this->dispatch('show-toast',
                type: 'error',
                message: __('common.plugin_uninstall_failed', ['error' => $e->getMessage()])
            );
        }
    }

    public function close()
    {
        $this->showModal = false;
        $this->reset(['pluginId', 'pluginName']);
    }

    public function render()
    {
        return view('livewire.admin.delete-plugin-modal');
    }
}
